/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.tools;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.eclipse.jface.preference.IPreferenceStore;
import org.netxms.api.client.Session;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class RegionalSettings {
    public static final int DATETIME_FORMAT_SERVER = 0;
    public static final int DATETIME_FORMAT_JVM = 1;
    public static final int DATETIME_FORMAT_CUSTOM = 2;
    private static int dateTimeFormat = 0;
    private static String dateFormatString;
    private static String timeFormatString;

    public static void updateFromPreferences() {
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        dateTimeFormat = ps.getInt("DATETIME_FORMAT");
        dateFormatString = ps.getString("DATE_FORMAT_STRING");
        timeFormatString = ps.getString("TIME_FORMAT_STRING");
    }

    public static DateFormat getDateTimeFormat() {
        switch (dateTimeFormat) {
            case 0: {
                Session session = ConsoleSharedData.getSession();
                return new SimpleDateFormat(String.valueOf(session.getDateFormat()) + " " + session.getTimeFormat());
            }
            case 2: {
                try {
                    return new SimpleDateFormat(String.valueOf(dateFormatString) + " " + timeFormatString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return DateFormat.getDateTimeInstance(3, 2);
                }
            }
        }
        return DateFormat.getDateTimeInstance(3, 2);
    }

    public static DateFormat getDateFormat() {
        switch (dateTimeFormat) {
            case 0: {
                Session session = ConsoleSharedData.getSession();
                return new SimpleDateFormat(session.getDateFormat());
            }
            case 2: {
                try {
                    return new SimpleDateFormat(dateFormatString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return DateFormat.getDateInstance(3);
                }
            }
        }
        return DateFormat.getDateInstance(3);
    }
}

