/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.actions;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DciValue;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public abstract class ShowDataComparisonChart
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private Object[] currentSelection = null;
    private long uniqueId = 0L;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        if (this.currentSelection != null) {
            String id = String.valueOf(Long.toString(this.uniqueId++)) + "&" + Integer.toString(this.getChartType());
            int i = 0;
            while (i < this.currentSelection.length) {
                long dciId = 0L;
                long nodeId = 0L;
                int source = 0;
                int dataType = 0;
                String name = null;
                String description = null;
                try {
                    if (this.currentSelection[i] instanceof DciValue) {
                        dciId = ((DciValue)this.currentSelection[i]).getId();
                        nodeId = ((DciValue)this.currentSelection[i]).getNodeId();
                        source = ((DciValue)this.currentSelection[i]).getSource();
                        dataType = ((DciValue)this.currentSelection[i]).getDataType();
                        name = URLEncoder.encode(((DciValue)this.currentSelection[i]).getName(), "UTF-8");
                        description = URLEncoder.encode(((DciValue)this.currentSelection[i]).getDescription(), "UTF-8");
                    } else if (this.currentSelection[i] instanceof DataCollectionItem) {
                        dciId = ((DataCollectionItem)this.currentSelection[i]).getId();
                        nodeId = ((DataCollectionItem)this.currentSelection[i]).getNodeId();
                        source = ((DataCollectionItem)this.currentSelection[i]).getOrigin();
                        dataType = ((DataCollectionItem)this.currentSelection[i]).getDataType();
                        name = URLEncoder.encode(((DataCollectionItem)this.currentSelection[i]).getName(), "UTF-8");
                        description = URLEncoder.encode(((DataCollectionItem)this.currentSelection[i]).getDescription(), "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    description = "<description unavailable>";
                }
                id = String.valueOf(id) + "&" + Long.toString(nodeId) + "@" + Long.toString(dciId) + "@" + Integer.toString(source) + "@" + Integer.toString(dataType) + "@" + name + "@" + description;
                ++i;
            }
            try {
                this.window.getActivePage().showView("org.netxms.ui.eclipse.perfview.views.DataComparisionView", id, 1);
            }
            catch (PartInitException e) {
                MessageDialogHelper.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view: " + e.getMessage()));
            }
            catch (IllegalArgumentException e) {
                MessageDialogHelper.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening view: " + e.getMessage()));
            }
        }
    }

    protected abstract int getChartType();

    public void selectionChanged(IAction action, ISelection selection) {
        Object element;
        this.currentSelection = selection instanceof IStructuredSelection && !selection.isEmpty() ? ((element = ((IStructuredSelection)selection).getFirstElement()) instanceof DciValue || element instanceof DataCollectionItem ? ((IStructuredSelection)selection).toArray() : null) : null;
        action.setEnabled(this.currentSelection != null && this.currentSelection.length > 0);
    }
}

