/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.objecttabs;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.PerfTabDci;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.perfview.PerfTabGraphSettings;
import org.netxms.ui.eclipse.perfview.objecttabs.internal.PerfTabGraph;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AnimatedImage;

public class PerformanceTab
extends ObjectTab {
    private Map<Long, PerfTabGraph> charts = new HashMap<Long, PerfTabGraph>();
    private ScrolledComposite scroller;
    private Composite chartArea;
    private AnimatedImage waitingImage = null;

    protected void createTabContent(Composite parent) {
        this.scroller = new ScrolledComposite(parent, 512);
        this.chartArea = new Composite((Composite)this.scroller, 0);
        this.chartArea.setBackground(SharedColors.getColor((String)"ObjectTab.Background", (Display)parent.getDisplay()));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        this.chartArea.setLayout((Layout)layout);
        this.scroller.setContent((Control)this.chartArea);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        this.scroller.getVerticalBar().setIncrement(20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = PerformanceTab.this.scroller.getClientArea();
                PerformanceTab.this.scroller.setMinSize(PerformanceTab.this.chartArea.computeSize(r.width, -1));
            }
        });
    }

    public void objectChanged(final AbstractObject object) {
        for (PerfTabGraph chart : this.charts.values()) {
            chart.dispose();
        }
        this.charts.clear();
        if (this.waitingImage != null) {
            this.waitingImage.dispose();
        }
        this.waitingImage = new AnimatedImage(this.chartArea, 0);
        this.waitingImage.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 2, 1));
        try {
            this.waitingImage.setImage(new URL("platform:/plugin/org.netxms.ui.eclipse.library/icons/loading.gif"));
        }
        catch (MalformedURLException malformedURLException) {}
        this.updateChartAreaLayout();
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        Job job = new Job("Update performance tab"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    final PerfTabDci[] items = session.getPerfTabItems(object.getObjectId());
                    new UIJob(PerformanceTab.this.getClientArea().getDisplay(), "Update performance tab"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (!PerformanceTab.this.getClientArea().isDisposed() && PerformanceTab.this.getObject().getObjectId() == object.getObjectId()) {
                                PerformanceTab.this.update(items);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                catch (Exception exception) {}
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void update(PerfTabDci[] items) {
        if (this.waitingImage != null) {
            this.waitingImage.dispose();
            this.waitingImage = null;
        }
        for (PerfTabGraph chart : this.charts.values()) {
            chart.dispose();
        }
        this.charts.clear();
        ArrayList<PerfTabGraphSettings> settings = new ArrayList<PerfTabGraphSettings>(items.length);
        int i = 0;
        while (i < items.length) {
            try {
                PerfTabGraphSettings s = PerfTabGraphSettings.createFromXml(items[i].getPerfTabSettings());
                if (s.isEnabled()) {
                    s.setRuntimeDciInfo(items[i]);
                    settings.add(s);
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        for (PerfTabGraphSettings s : settings) {
            s.fixParentDciId(settings);
        }
        Collections.sort(settings, new Comparator<PerfTabGraphSettings>(){

            @Override
            public int compare(PerfTabGraphSettings o1, PerfTabGraphSettings o2) {
                int result = Long.signum(o1.getParentDciId() - o2.getParentDciId());
                if (result == 0) {
                    result = Integer.signum(o1.getOrder() - o2.getOrder());
                }
                if (result == 0) {
                    result = o1.getParentDciId() == 0L ? o1.getRuntimeTitle().compareToIgnoreCase(o2.getRuntimeTitle()) : o1.getRuntimeName().compareToIgnoreCase(o2.getRuntimeName());
                }
                return result;
            }
        });
        for (PerfTabGraphSettings s : settings) {
            PerfTabGraph chart;
            if (s.getParentDciId() == 0L) {
                chart = new PerfTabGraph(this.chartArea, this.getObject().getObjectId(), s.getRuntimeDciInfo(), s);
                this.charts.put(s.getRuntimeDciInfo().getId(), chart);
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                gd.heightHint = 250;
                chart.setLayoutData(gd);
                continue;
            }
            chart = this.charts.get(s.getParentDciId());
            if (chart == null) continue;
            chart.addItem(s.getRuntimeDciInfo(), s);
        }
        for (PerfTabGraph chart : this.charts.values()) {
            chart.start();
        }
        this.updateChartAreaLayout();
    }

    private void updateChartAreaLayout() {
        this.chartArea.layout();
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.chartArea.computeSize(r.width, -1));
    }

    public boolean showForObject(AbstractObject object) {
        return object instanceof AbstractNode;
    }
}

