/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.ui.eclipse.datacollection.api.DataCollectionObjectEditor;
import org.netxms.ui.eclipse.datacollection.widgets.DciSelector;
import org.netxms.ui.eclipse.perfview.PerfTabGraphSettings;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class PerfTab
extends PropertyPage {
    private DataCollectionObjectEditor editor;
    private DataCollectionItem dci;
    private PerfTabGraphSettings settings;
    private Button checkShow;
    private LabeledText title;
    private LabeledText name;
    private ColorSelector color;
    private Combo type;
    private Spinner orderNumber;
    private Button checkShowThresholds;
    private DciSelector parentDci;

    protected Control createContents(Composite parent) {
        this.editor = (DataCollectionObjectEditor)this.getElement().getAdapter(DataCollectionObjectEditor.class);
        this.dci = this.editor.getObjectAsItem();
        try {
            this.settings = PerfTabGraphSettings.createFromXml(this.dci.getPerfTabSettings());
        }
        catch (Exception exception) {
            this.settings = new PerfTabGraphSettings();
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 4;
        dialogArea.setLayout((Layout)layout);
        this.checkShow = new Button(dialogArea, 32);
        this.checkShow.setText("&Show on performance tab");
        this.checkShow.setSelection(this.settings.isEnabled());
        GridData gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        this.checkShow.setLayoutData((Object)gd);
        this.title = new LabeledText(dialogArea, 0);
        this.title.setLabel("Title");
        this.title.setText(this.settings.getTitle());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.title.setLayoutData((Object)gd);
        Composite colors = new Composite(dialogArea, 0);
        colors.setLayout((Layout)new RowLayout(512));
        new Label(colors, 0).setText("Color");
        this.color = new ColorSelector(colors);
        this.color.setColorValue(ColorConverter.rgbFromInt((int)this.settings.getColorAsInt()));
        this.type = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Type", (Object)new GridData(16384, 0x1000000, false, false));
        this.type.add("Line");
        this.type.add("Area");
        this.type.select(this.settings.getType());
        this.orderNumber = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)"Order", (int)0, (int)65535, (Object)new GridData(16384, 0x1000000, false, false));
        this.orderNumber.setSelection(this.settings.getOrder());
        this.parentDci = new DciSelector(dialogArea, 0, false);
        this.parentDci.setDciId(this.dci.getNodeId(), this.settings.getParentDciId());
        this.parentDci.setFixedNode(true);
        this.parentDci.setLabel("Attach to another DCI");
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.parentDci.setLayoutData((Object)gd);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name in legend");
        this.name.setText(this.settings.getName());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = layout.numColumns;
        this.name.setLayoutData((Object)gd);
        this.checkShowThresholds = new Button(dialogArea, 32);
        this.checkShowThresholds.setText("&Show thresholds on graph");
        this.checkShowThresholds.setSelection(this.settings.isShowThresholds());
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        this.checkShowThresholds.setLayoutData((Object)gd);
        return dialogArea;
    }

    private void applyChanges(boolean isApply) {
        this.settings.setEnabled(this.checkShow.getSelection());
        this.settings.setTitle(this.title.getText());
        this.settings.setName(this.name.getText());
        this.settings.setColor(ColorConverter.rgbToInt((RGB)this.color.getColorValue()));
        this.settings.setType(this.type.getSelectionIndex());
        this.settings.setOrder(this.orderNumber.getSelection());
        this.settings.setShowThresholds(this.checkShowThresholds.getSelection());
        this.settings.setParentDciId(this.parentDci.getDciId());
        try {
            this.dci.setPerfTabSettings(this.settings.createXml());
        }
        catch (Exception exception) {
            this.dci.setPerfTabSettings(null);
        }
        this.editor.modify();
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        PerfTabGraphSettings defaults = new PerfTabGraphSettings();
        this.checkShow.setSelection(defaults.isEnabled());
        this.title.setText(defaults.getTitle());
        this.color.setColorValue(ColorConverter.rgbFromInt((int)defaults.getColorAsInt()));
        this.parentDci.setDciId(0L, 0L);
    }
}

