/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.api.client.scripts.Script;
import org.netxms.api.client.scripts.ScriptLibraryManager;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class SelectScriptDialog
extends Dialog {
    private TableViewer viewer;
    private Script script;

    public SelectScriptDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Select script");
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        new Label(dialogArea, 0).setText("Available scripts");
        this.viewer = new TableViewer(dialogArea, 67584);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Script)element).getName();
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Script s1 = (Script)e1;
                Script s2 = (Script)e2;
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectScriptDialog.this.okPressed();
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        final ScriptLibraryManager session = (ScriptLibraryManager)ConsoleSharedData.getSession();
        new ConsoleJob("Get script list", null, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List scripts = session.getScriptLibrary();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        SelectScriptDialog.this.viewer.setInput((Object)scripts.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get script list from server";
            }
        }.start();
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"You must select at script from list and then press OK.");
            return;
        }
        this.script = (Script)selection.getFirstElement();
        super.okPressed();
    }

    public Script getScript() {
        return this.script;
    }
}

