/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.api.client.reporting.ReportParameter;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;
import org.netxms.ui.eclipse.shared.SharedIcons;

public class ObjectFieldEditor
extends FieldEditor {
    private static final String EMPTY_SELECTION_TEXT = "<none>";
    private CLabel text;
    private long objectId = 0L;
    private WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();

    public ObjectFieldEditor(ReportParameter parameter, FormToolkit toolkit, Composite parent) {
        super(parameter, toolkit, parent);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ObjectFieldEditor.this.labelProvider.dispose();
            }
        });
    }

    @Override
    protected void createContent(Composite parent) {
        Composite content = this.toolkit.createComposite(parent, 2048);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        content.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        content.setLayout((Layout)layout);
        this.text = new CLabel(content, 0);
        this.toolkit.adapt((Composite)this.text);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.text.setLayoutData((Object)gd);
        this.text.setText(EMPTY_SELECTION_TEXT);
        ImageHyperlink selectionLink = this.toolkit.createImageHyperlink(content, 0);
        selectionLink.setImage(SharedIcons.IMG_FIND);
        selectionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ObjectFieldEditor.this.selectObject();
            }
        });
    }

    private void selectObject() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), null, null);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            AbstractObject[] objects = dlg.getSelectedObjects(AbstractObject.class);
            if (objects.length > 0) {
                this.objectId = objects[0].getObjectId();
                this.text.setText(objects[0].getObjectName());
                this.text.setImage(this.labelProvider.getImage((Object)objects[0]));
            } else {
                this.objectId = 0L;
                this.text.setText(EMPTY_SELECTION_TEXT);
                this.text.setImage(null);
            }
        }
    }

    @Override
    public String getValue() {
        return Long.toString(this.objectId);
    }
}

