/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.situations.Situation;
import org.netxms.ui.eclipse.epp.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class SituationCache {
    private static Map<Long, Situation> situations = new HashMap<Long, Situation>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(NXCSession session, Display display) {
        try {
            List list = session.getSituations();
            Map<Long, Situation> map = situations;
            synchronized (map) {
                for (Situation s : list) {
                    situations.put(s.getId(), s);
                }
            }
            session.subscribe(64);
        }
        catch (Exception e) {
            if (e instanceof NXCException && ((NXCException)e).getErrorCode() == 2) {
                return;
            }
            new UIJob(display, Messages.SituationCache_JobTitle){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    MessageDialogHelper.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.SituationCache_Error, (String)(String.valueOf(Messages.SituationCache_ErrorText) + e.getLocalizedMessage()));
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        session.addListener(new SessionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notificationHandler(SessionNotification n) {
                switch (n.getCode()) {
                    case 101: 
                    case 103: {
                        Map map = situations;
                        synchronized (map) {
                            situations.put(n.getSubCode(), (Situation)n.getObject());
                            break;
                        }
                    }
                    case 102: {
                        Map map = situations;
                        synchronized (map) {
                            situations.remove(n.getSubCode());
                            break;
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Situation[] getAllSituations() {
        Situation[] list;
        Map<Long, Situation> map = situations;
        synchronized (map) {
            list = situations.values().toArray(new Situation[situations.size()]);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Situation findSituation(long id) {
        Situation s;
        Map<Long, Situation> map = situations;
        synchronized (map) {
            s = situations.get(id);
        }
        return s;
    }
}

