/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.api.client.images.LibraryImage;
import org.netxms.base.NXCommon;
import org.netxms.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.netxms.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.netxms.nebula.widgets.gallery.DefaultGalleryGroupRenderer;
import org.netxms.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.netxms.nebula.widgets.gallery.Gallery;
import org.netxms.nebula.widgets.gallery.GalleryItem;
import org.netxms.ui.eclipse.imagelibrary.Activator;
import org.netxms.ui.eclipse.imagelibrary.Messages;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageUpdateListener;

public class ImageSelectionDialog
extends Dialog
implements SelectionListener,
MouseListener,
ImageUpdateListener {
    public static final int NONE = 0;
    public static final int ALLOW_DEFAULT = 1;
    private static final String SELECT_IMAGE_CY = "SelectImage.cy";
    private static final String SELECT_IMAGE_CX = "SelectImage.cx";
    private static final int DEFAULT_ID = 1025;
    private Gallery gallery;
    private LibraryImage libraryImage;
    private Image imageObject;
    private int flags;
    private int maxWidth = Integer.MAX_VALUE;
    private int maxHeight = Integer.MAX_VALUE;

    public ImageSelectionDialog(Shell parentShell) {
        this(parentShell, 0);
    }

    public ImageSelectionDialog(Shell parentShell, int flags) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.flags = flags;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ImageSelectionDialog_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt(SELECT_IMAGE_CX), settings.getInt(SELECT_IMAGE_CY));
        }
        catch (NumberFormatException numberFormatException) {
            newShell.setSize(400, 350);
        }
    }

    public boolean close() {
        ImageProvider.getInstance().removeUpdateListener(this);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        FillLayout layout = new FillLayout();
        dialogArea.setLayout((Layout)layout);
        this.gallery = new Gallery(dialogArea, 512);
        DefaultGalleryGroupRenderer galleryGroupRenderer = new DefaultGalleryGroupRenderer();
        galleryGroupRenderer.setMinMargin(2);
        galleryGroupRenderer.setItemHeight(48);
        galleryGroupRenderer.setItemWidth(48);
        galleryGroupRenderer.setAutoMargin(true);
        galleryGroupRenderer.setAlwaysExpanded(true);
        this.gallery.setGroupRenderer((AbstractGalleryGroupRenderer)galleryGroupRenderer);
        DefaultGalleryItemRenderer itemRenderer = new DefaultGalleryItemRenderer();
        this.gallery.setItemRenderer((AbstractGalleryItemRenderer)itemRenderer);
        this.gallery.addSelectionListener((SelectionListener)this);
        this.gallery.addMouseListener((MouseListener)this);
        ImageProvider.getInstance().addUpdateListener(this);
        this.refreshImages();
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        GalleryItem[] selection = this.gallery.getSelection();
        if (selection.length > 0) {
            this.libraryImage = (LibraryImage)selection[0].getData();
            this.imageObject = selection[0].getImage();
        }
        this.saveSettings();
        super.okPressed();
    }

    private void defaultPressed() {
        this.imageObject = null;
        this.libraryImage = new LibraryImage();
        this.saveSettings();
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (1025 == buttonId) {
            this.defaultPressed();
        }
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put(SELECT_IMAGE_CX, size.x);
        settings.put(SELECT_IMAGE_CY, size.y);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if ((this.flags & 1) == 1) {
            this.createButton(parent, 1025, Messages.ImageSelectionDialog_Default, false);
        }
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void refreshImages() {
        ImageProvider provider = ImageProvider.getInstance();
        List<LibraryImage> imageLibrary = provider.getImageLibrary();
        HashMap categories = new HashMap();
        for (LibraryImage image : imageLibrary) {
            String category = image.getCategory();
            Image swtImage = provider.getImage(image.getGuid());
            Rectangle bounds = swtImage.getBounds();
            if (bounds.height > this.maxHeight || bounds.width > this.maxWidth) continue;
            if (!categories.containsKey(category)) {
                categories.put(category, new ArrayList());
            }
            ((List)categories.get(category)).add(image);
        }
        this.gallery.removeAll();
        for (String category : categories.keySet()) {
            GalleryItem categoryItem = new GalleryItem(this.gallery, 0);
            categoryItem.setText(category);
            List categoryImages = (List)categories.get(category);
            for (LibraryImage image : categoryImages) {
                GalleryItem imageItem = new GalleryItem(categoryItem, 0);
                imageItem.setText(image.getName());
                imageItem.setImage(provider.getImage(image.getGuid()));
                imageItem.setData((Object)image);
            }
        }
        this.gallery.redraw();
    }

    public Image getImage() {
        return this.imageObject;
    }

    public UUID getGuid() {
        return this.libraryImage == null ? NXCommon.EMPTY_GUID : this.libraryImage.getGuid();
    }

    public LibraryImage getLibraryImage() {
        return this.libraryImage;
    }

    public void widgetSelected(SelectionEvent e) {
        GalleryItem[] selection = this.gallery.getSelection();
        if (selection.length > 0) {
            this.getButton(0).setEnabled(true);
        } else {
            this.getButton(0).setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
        GalleryItem[] selection = this.gallery.getSelection();
        if (selection.length > 0) {
            this.okPressed();
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    @Override
    public void imageUpdated(UUID guid) {
        Shell shell = this.getShell();
        if (shell != null) {
            Display display = shell.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImageSelectionDialog.this.refreshImages();
                }
            });
        }
    }

    public void setMaxImageDimensions(int width, int height) {
        this.maxWidth = width;
        this.maxHeight = height;
        Shell shell = this.getShell();
        if (shell != null) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImageSelectionDialog.this.refreshImages();
                }
            });
        }
    }
}

