/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.TableElement;

public class Capabilities
extends TableElement {
    public Capabilities(Composite parent, AbstractObject object) {
        super(parent, object);
    }

    @Override
    protected String getTitle() {
        return "Capabilities";
    }

    @Override
    protected void fillTable() {
        if (!(this.getObject() instanceof AbstractNode)) {
            return;
        }
        AbstractNode node = (AbstractNode)this.getObject();
        this.addFlag("isAgent", (node.getFlags() & 2) != 0);
        this.addFlag("isBridge", (node.getFlags() & 4) != 0);
        this.addFlag("isCDP", (node.getFlags() & 0x200) != 0);
        this.addFlag("isDot1x", (node.getFlags() & 0x4000) != 0);
        this.addFlag("isLLDP", (node.getFlags() & 0x800) != 0);
        this.addFlag("isNDP", (node.getFlags() & 0x400) != 0);
        this.addFlag("isPrinter", (node.getFlags() & 0x20) != 0);
        this.addFlag("isRouter", (node.getFlags() & 8) != 0);
        this.addFlag("isSMCLP", (node.getFlags() & 0x200000) != 0);
        this.addFlag("isSNMP", (node.getFlags() & 1) != 0);
        this.addFlag("isSTP", (node.getFlags() & 0x8000) != 0);
        this.addFlag("isVRRP", (node.getFlags() & 0x1000) != 0);
        this.addFlag("hasEntityMIB", (node.getFlags() & 0x10000) != 0);
        this.addFlag("hasIfXTable", (node.getFlags() & 0x20000) != 0);
        if ((node.getFlags() & 1) != 0) {
            this.addPair("snmpPort", Integer.toString(node.getSnmpPort()));
            this.addPair("snmpVersion", this.getSnmpVersionName(node.getSnmpVersion()));
        }
    }

    private void addFlag(String name, boolean value) {
        this.addPair(name, value ? "Yes" : "No");
    }

    private String getSnmpVersionName(int version) {
        switch (version) {
            case 0: {
                return "1";
            }
            case 1: {
                return "2c";
            }
            case 3: {
                return "3";
            }
        }
        return "???";
    }

    @Override
    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof AbstractNode;
    }
}

