/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.actions;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.DciRemoveConfirmationDialog;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ChildObjectListDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class RemoveTemplate
implements IObjectActionDelegate {
    private Shell shell;
    private ViewPart viewPart;
    private long parentId;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }

    public void run(IAction action) {
        DciRemoveConfirmationDialog dlg2;
        final ChildObjectListDialog dlg = new ChildObjectListDialog(this.shell, this.parentId, null);
        if (dlg.open() == 0 && (dlg2 = new DciRemoveConfirmationDialog(this.shell)).open() == 0) {
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            new ConsoleJob(Messages.RemoveTemplate_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", null){

                protected String getErrorMessage() {
                    return Messages.RemoveTemplate_JobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    List objects = dlg.getSelectedObjects();
                    int i = 0;
                    while (i < objects.size()) {
                        session.removeTemplate(RemoveTemplate.this.parentId, ((AbstractObject)objects.get(i)).getObjectId(), dlg2.getRemoveFlag());
                        ++i;
                    }
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof Template) {
                action.setEnabled(true);
                this.parentId = ((AbstractObject)obj).getObjectId();
            } else {
                action.setEnabled(false);
                this.parentId = 0L;
            }
        } else {
            action.setEnabled(false);
            this.parentId = 0L;
        }
    }
}

