/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.api;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.api.DataCollectionObjectListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;

public class DataCollectionObjectEditor {
    DataCollectionObject object;
    private Runnable timer;
    private Set<DataCollectionObjectListener> listeners = new HashSet<DataCollectionObjectListener>();

    public DataCollectionObjectEditor(DataCollectionObject object) {
        this.object = object;
        this.timer = new Runnable(){

            @Override
            public void run() {
                DataCollectionObjectEditor.this.doObjectModification();
            }
        };
    }

    private void doObjectModification() {
        new ConsoleJob(Messages.DataCollectionObjectEditor_JobName, null, "org.netxms.ui.eclipse.datacollection", null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DataCollectionObjectEditor dataCollectionObjectEditor = DataCollectionObjectEditor.this;
                synchronized (dataCollectionObjectEditor) {
                    DataCollectionObjectEditor.this.object.getOwner().modifyObject(DataCollectionObjectEditor.this.object);
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Object data = (this).DataCollectionObjectEditor.this.object.getOwner().getUserData();
                        if (data != null && data instanceof TableViewer) {
                            ((TableViewer)data).update((Object)(this).DataCollectionObjectEditor.this.object, null);
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return Messages.DataCollectionObjectEditor_JobError;
            }
        }.start();
    }

    public void modify() {
        Display.getCurrent().timerExec(-1, this.timer);
        Display.getCurrent().timerExec(200, this.timer);
    }

    public void addListener(DataCollectionObjectListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DataCollectionObjectListener listener) {
        this.listeners.remove(listener);
    }

    public void fireOnSelectItemListeners(int origin, String name, String description, int dataType) {
        for (DataCollectionObjectListener l : this.listeners) {
            l.onSelectItem(origin, name, description, dataType);
        }
    }

    public void fireOnSelectTableListeners(int origin, String name, String description) {
        for (DataCollectionObjectListener l : this.listeners) {
            l.onSelectTable(origin, name, description);
        }
    }

    public DataCollectionObject getObject() {
        return this.object;
    }

    public DataCollectionItem getObjectAsItem() {
        return (DataCollectionItem)this.object;
    }

    public DataCollectionTable getObjectAsTable() {
        return (DataCollectionTable)this.object;
    }
}

