/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.netxms.base.GeoLocation;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.osm.Messages;
import org.netxms.ui.eclipse.osm.tools.MapAccessor;
import org.netxms.ui.eclipse.osm.views.AbstractGeolocationView;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class WorldMap
extends AbstractGeolocationView {
    public static final String ID = "org.netxms.ui.eclipse.osm.views.WorldMap";
    private GeoLocation initialLocation = new GeoLocation(0.0, 0.0);
    private int initialZoom = 2;
    private Action actionPlaceObject;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        if (memento != null) {
            if (memento.getInteger("zoom") != null) {
                this.initialZoom = memento.getInteger("zoom");
            }
            Float lat = memento.getFloat("latitude");
            Float lon = memento.getFloat("longitude");
            if (lat != null && lon != null) {
                this.initialLocation = new GeoLocation((double)lat.floatValue(), (double)lon.floatValue());
            }
        }
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        MapAccessor m = this.getMapAccessor();
        memento.putFloat("latitude", (float)m.getLatitude());
        memento.putFloat("longitude", (float)m.getLongitude());
        memento.putInteger("zoom", m.getZoom());
    }

    @Override
    protected GeoLocation getInitialCenterPoint() {
        return this.initialLocation;
    }

    @Override
    protected int getInitialZoomLevel() {
        return this.initialZoom;
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.actionPlaceObject = new Action(Messages.WorldMap_PlaceObject){

            public void run() {
                WorldMap.this.placeObject();
            }
        };
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        super.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionPlaceObject);
    }

    private void placeObject() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, ObjectSelectionDialog.createNodeSelectionFilter((boolean)true));
        if (dlg.open() == 0) {
            final NXCObjectModificationData md = new NXCObjectModificationData(((AbstractObject)dlg.getSelectedObjects().get(0)).getObjectId());
            md.setGeolocation(this.map.getLocationAtPoint(this.map.getCurrentPoint()));
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            new ConsoleJob(Messages.WorldMap_JobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.osm", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.modifyObject(md);
                }

                protected String getErrorMessage() {
                    return Messages.WorldMap_JobError;
                }
            }.start();
        }
    }
}

