/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.api.client.Session;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.api.client.users.User;
import org.netxms.api.client.users.UserManager;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.usermanager.Messages;

public class Authentication
extends PropertyPage {
    private Session session = ConsoleSharedData.getSession();
    private User object;
    private Button checkDisabled;
    private Button checkChangePassword;
    private Button checkFixedPassword;
    private Combo comboAuthMethod;
    private Combo comboMappingMethod;
    private Text textMappingData;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (User)this.getElement().getAdapter(AbstractUserObject.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        Group groupFlags = new Group(dialogArea, 0);
        groupFlags.setText(Messages.Authentication_AccountOptions);
        GridLayout groupFlagsLayout = new GridLayout();
        groupFlags.setLayout((Layout)groupFlagsLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupFlags.setLayoutData((Object)gridData);
        this.checkDisabled = new Button((Composite)groupFlags, 32);
        this.checkDisabled.setText(Messages.Authentication_AccountDisabled);
        this.checkDisabled.setSelection(this.object.isDisabled());
        this.checkChangePassword = new Button((Composite)groupFlags, 32);
        this.checkChangePassword.setText(Messages.Authentication_MustChangePassword);
        this.checkChangePassword.setSelection(this.object.isPasswordChangeNeeded());
        this.checkFixedPassword = new Button((Composite)groupFlags, 32);
        this.checkFixedPassword.setText(Messages.Authentication_CannotChangePassword);
        this.checkFixedPassword.setSelection(this.object.isPasswordChangeForbidden());
        Group groupMethod = new Group(dialogArea, 0);
        groupMethod.setText(Messages.Authentication_AuthMethod_Group);
        GridLayout groupMethodLayout = new GridLayout();
        groupMethodLayout.numColumns = 2;
        groupMethod.setLayout((Layout)groupMethodLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupMethod.setLayoutData((Object)gridData);
        Label label = new Label((Composite)groupMethod, 0);
        label.setText(Messages.Authentication_AuthMethod_Label);
        this.comboAuthMethod = new Combo((Composite)groupMethod, 12);
        this.comboAuthMethod.add(Messages.Authentication_Password);
        this.comboAuthMethod.add(Messages.Authentication_RADIUS);
        this.comboAuthMethod.add(Messages.Authentication_Certificate);
        this.comboAuthMethod.add(Messages.Authentication_CertificateOrPassword);
        this.comboAuthMethod.add(Messages.Authentication_CertificateOrRADIUS);
        this.comboAuthMethod.select(this.object.getAuthMethod());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboAuthMethod.setLayoutData((Object)gridData);
        label = new Label((Composite)groupMethod, 0);
        label.setText(Messages.Authentication_CertMapping);
        this.comboMappingMethod = new Combo((Composite)groupMethod, 12);
        this.comboMappingMethod.add(Messages.Authentication_Subject);
        this.comboMappingMethod.add(Messages.Authentication_PublicKey);
        this.comboMappingMethod.select(this.object.getCertMappingMethod());
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboMappingMethod.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        this.textMappingData = WidgetHelper.createLabeledText((Composite)groupMethod, (int)2052, (int)-1, (String)Messages.Authentication_MappingData, (String)this.object.getCertMappingData(), (Object)gridData);
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        int flags = 0;
        if (this.checkDisabled.getSelection()) {
            flags |= 4;
        }
        if (this.checkChangePassword.getSelection()) {
            flags |= 8;
        }
        if (this.checkFixedPassword.getSelection()) {
            flags |= 0x10;
        }
        this.object.setFlags(flags);
        this.object.setAuthMethod(this.comboAuthMethod.getSelectionIndex());
        this.object.setCertMappingMethod(this.comboMappingMethod.getSelectionIndex());
        this.object.setCertMappingData(this.textMappingData.getText());
        if (isApply) {
            this.setValid(false);
        }
        new ConsoleJob(Messages.Authentication_JobTitle, null, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ((UserManager)Authentication.this.session).modifyUserDBObject((AbstractUserObject)Authentication.this.object, 200);
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Authentication.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return Messages.Authentication_JobError;
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

