/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.netxms.client.log.ColumnFilter;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.widgets.ConditionEditor;

public class TimestampConditionEditor
extends ConditionEditor {
    private static final String[] OPERATIONS = new String[]{Messages.TimestampConditionEditor_Between, Messages.TimestampConditionEditor_Before, Messages.TimestampConditionEditor_After};
    private DateTime datePicker1;
    private DateTime timePicker1;
    private DateTime datePicker2;
    private DateTime timePicker2;
    private Label andLabel;

    public TimestampConditionEditor(Composite parent, FormToolkit toolkit) {
        super(parent, toolkit);
    }

    @Override
    protected String[] getOperations() {
        return OPERATIONS;
    }

    @Override
    protected void createContent(Composite parent) {
        Composite group = new Composite((Composite)this, 0);
        RowLayout layout = new RowLayout();
        layout.type = 256;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        this.datePicker1 = new DateTime(group, 36);
        this.datePicker1.setDate(c.get(1), c.get(2), c.get(5));
        this.timePicker1 = new DateTime(group, 128);
        this.timePicker1.setTime(c.get(11), c.get(12), c.get(13));
        this.andLabel = this.toolkit.createLabel(group, Messages.TimestampConditionEditor_And);
        this.datePicker2 = new DateTime(group, 36);
        this.datePicker2.setDate(c.get(1), c.get(2), c.get(5));
        this.timePicker2 = new DateTime(group, 128);
        this.timePicker2.setTime(c.get(11), c.get(12), c.get(13));
    }

    @Override
    protected void operationSelectionChanged(int selectionIndex) {
        if (selectionIndex == 0) {
            this.andLabel.setVisible(true);
            this.datePicker2.setVisible(true);
            this.timePicker2.setVisible(true);
        } else {
            this.andLabel.setVisible(false);
            this.datePicker2.setVisible(false);
            this.timePicker2.setVisible(false);
        }
    }

    @Override
    public ColumnFilter createFilter() {
        ColumnFilter filter;
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(this.datePicker1.getYear(), this.datePicker1.getMonth(), this.datePicker1.getDay(), this.timePicker1.getHours(), this.timePicker1.getMinutes(), this.timePicker1.getSeconds());
        long timestamp = c.getTimeInMillis() / 1000L;
        switch (this.getSelectedOperation()) {
            case 0: {
                c.clear();
                c.set(this.datePicker2.getYear(), this.datePicker2.getMonth(), this.datePicker2.getDay(), this.timePicker2.getHours(), this.timePicker2.getMinutes(), this.timePicker2.getSeconds());
                filter = new ColumnFilter(timestamp, c.getTimeInMillis() / 1000L);
                break;
            }
            case 1: {
                filter = new ColumnFilter(4, timestamp);
                break;
            }
            case 2: {
                filter = new ColumnFilter(5, timestamp);
                break;
            }
            default: {
                filter = new ColumnFilter(timestamp, timestamp);
            }
        }
        return filter;
    }
}

