/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.BasicSplashHandler;
import org.netxms.ui.eclipse.console.Messages;

public class SplashHandler
extends BasicSplashHandler {
    private static SplashHandler instance;

    public static SplashHandler getInstance() {
        return instance;
    }

    public void init(Shell splash) {
        int foregroundColorInteger;
        super.init(splash);
        instance = this;
        String progressRectString = null;
        String messageRectString = null;
        String foregroundColorString = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            progressRectString = product.getProperty("startupProgressRect");
            messageRectString = product.getProperty("startupMessageRect");
            foregroundColorString = product.getProperty("startupForegroundColor");
        }
        Rectangle progressRect = StringConverter.asRectangle((String)progressRectString, (Rectangle)new Rectangle(10, 10, 300, 15));
        this.setProgressRect(progressRect);
        Rectangle messageRect = StringConverter.asRectangle((String)messageRectString, (Rectangle)new Rectangle(10, 35, 300, 15));
        this.setMessageRect(messageRect);
        try {
            foregroundColorInteger = Integer.parseInt(foregroundColorString, 16);
        }
        catch (Exception exception) {
            foregroundColorInteger = 13817855;
        }
        this.setForeground(new RGB((foregroundColorInteger & 0xFF0000) >> 16, (foregroundColorInteger & 0xFF00) >> 8, foregroundColorInteger & 0xFF));
        final Color versionColor = new Color((Device)Display.getCurrent(), 56, 56, 52);
        final Font versionFont = new Font((Device)Display.getCurrent(), "Verdana", 9, 1);
        Composite content = this.getContent();
        content.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(versionColor);
                e.gc.setFont(versionFont);
                e.gc.drawText(String.valueOf(Messages.SplashHandler_Version) + "1.2.8", 209, 181, true);
            }
        });
        content.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                versionColor.dispose();
                versionFont.dispose();
            }
        });
    }
}

