/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.tools.TextFieldValidator;

public class NumericTextFieldValidator
implements TextFieldValidator {
    private long min;
    private long max;
    private String range;

    public NumericTextFieldValidator(long min, long max) {
        this.min = min;
        this.max = max;
        this.range = String.valueOf(Long.toString(min)) + Messages.NumericTextFieldValidator_RangeSeparator + Long.toString(max);
    }

    @Override
    public boolean validate(String text) {
        try {
            long value = Long.parseLong(text);
            return value >= this.min && value <= this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    public String getErrorMessage(String text, String label) {
        return String.valueOf(Messages.NumericTextFieldValidator_ErrorMessage_Part1) + this.range + Messages.NumericTextFieldValidator_ErrorMessage_Part2 + label + Messages.NumericTextFieldValidator_ErrorMessage_Part3;
    }
}

