/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.internal.SeparatorConfig;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class SeparatorProperties
extends PropertyPage {
    private SeparatorConfig config;
    private ColorSelector foreground;
    private ColorSelector background;
    private Scale lineWidthScale;
    private Spinner lineWidthSpinner;
    private Spinner marginLeft;
    private Spinner marginRight;
    private Spinner marginTop;
    private Spinner marginBottom;

    protected Control createContents(Composite parent) {
        this.config = (SeparatorConfig)this.getElement().getAdapter(SeparatorConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Composite fgArea = new Composite(dialogArea, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        fgArea.setLayoutData((Object)gd);
        RowLayout areaLayout = new RowLayout();
        areaLayout.type = 256;
        areaLayout.marginBottom = 0;
        areaLayout.marginTop = 0;
        areaLayout.marginLeft = 0;
        areaLayout.marginRight = 0;
        fgArea.setLayout((Layout)areaLayout);
        new Label(fgArea, 0).setText(Messages.LabelProperties_TextColor);
        this.foreground = new ColorSelector(fgArea);
        this.foreground.setColorValue(ColorConverter.rgbFromInt((int)this.config.getForegroundColorAsInt()));
        Composite bgArea = new Composite(dialogArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        bgArea.setLayoutData((Object)gd);
        areaLayout = new RowLayout();
        areaLayout.type = 256;
        areaLayout.marginBottom = 0;
        areaLayout.marginTop = 0;
        areaLayout.marginLeft = 0;
        areaLayout.marginRight = 0;
        bgArea.setLayout((Layout)areaLayout);
        new Label(bgArea, 0).setText(Messages.LabelProperties_BgColor);
        this.background = new ColorSelector(bgArea);
        this.background.setColorValue(ColorConverter.rgbFromInt((int)this.config.getBackgroundColorAsInt()));
        Composite lineWidthGroup = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        lineWidthGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        lineWidthGroup.setLayoutData((Object)gd);
        Label label = new Label(lineWidthGroup, 0);
        label.setText(Messages.SeparatorProperties_LineWidth);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.lineWidthScale = new Scale(lineWidthGroup, 256);
        this.lineWidthScale.setMinimum(0);
        this.lineWidthScale.setMaximum(15);
        this.lineWidthScale.setSelection(this.config.getLineWidth());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.lineWidthScale.setLayoutData((Object)gd);
        this.lineWidthScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SeparatorProperties.this.lineWidthSpinner.setSelection(SeparatorProperties.this.lineWidthScale.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.lineWidthSpinner = new Spinner(lineWidthGroup, 2048);
        this.lineWidthSpinner.setMinimum(1);
        this.lineWidthSpinner.setMaximum(600);
        this.lineWidthSpinner.setSelection(this.config.getLineWidth());
        this.lineWidthSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SeparatorProperties.this.lineWidthScale.setSelection(SeparatorProperties.this.lineWidthSpinner.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.marginLeft = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.SeparatorProperties_LeftMargin, (int)0, (int)255, (Object)"WidgetHelper::default_layout_data");
        this.marginLeft.setSelection(this.config.getLeftMargin());
        this.marginRight = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.SeparatorProperties_RightMargin, (int)0, (int)255, (Object)"WidgetHelper::default_layout_data");
        this.marginRight.setSelection(this.config.getRightMargin());
        this.marginTop = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.SeparatorProperties_TopMargin, (int)0, (int)255, (Object)"WidgetHelper::default_layout_data");
        this.marginTop.setSelection(this.config.getTopMargin());
        this.marginBottom = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)Messages.SeparatorProperties_BottomMargin, (int)0, (int)255, (Object)"WidgetHelper::default_layout_data");
        this.marginBottom.setSelection(this.config.getBottomMargin());
        return dialogArea;
    }

    public boolean performOk() {
        this.config.setForeground("0x" + Integer.toHexString(ColorConverter.rgbToInt((RGB)this.foreground.getColorValue())));
        this.config.setBackground("0x" + Integer.toHexString(ColorConverter.rgbToInt((RGB)this.background.getColorValue())));
        this.config.setLineWidth(this.lineWidthScale.getSelection());
        this.config.setLeftMargin(this.marginLeft.getSelection());
        this.config.setRightMargin(this.marginRight.getSelection());
        this.config.setTopMargin(this.marginTop.getSelection());
        this.config.setBottomMargin(this.marginBottom.getSelection());
        return true;
    }
}

