/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartDciConfig;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.charts.api.DialChart;
import org.netxms.ui.eclipse.dashboard.widgets.ComparisonChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DialChartConfig;

public class DialChartElement
extends ComparisonChartElement {
    private DialChartConfig config;

    public DialChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = DialChartConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new DialChartConfig();
        }
        this.refreshInterval = this.config.getRefreshRate() * 1000;
        this.chart = ChartFactory.createDialChart((Composite)this, (int)0);
        this.chart.setChartTitle(this.config.getTitle());
        this.chart.setTitleVisible(this.config.isShowTitle());
        this.chart.setLegendVisible(this.config.isShowLegend());
        ((DialChart)this.chart).setLegendInside(this.config.isLegendInside());
        ((DialChart)this.chart).setVertical(this.config.isVertical());
        ((DialChart)this.chart).setMinValue(this.config.getMinValue());
        ((DialChart)this.chart).setMaxValue(this.config.getMaxValue());
        ((DialChart)this.chart).setLeftYellowZone(this.config.getLeftYellowZone());
        ((DialChart)this.chart).setLeftRedZone(this.config.getLeftRedZone());
        ((DialChart)this.chart).setRightYellowZone(this.config.getRightYellowZone());
        ((DialChart)this.chart).setRightRedZone(this.config.getRightRedZone());
        int index = 0;
        ChartDciConfig[] chartDciConfigArray = this.config.getDciList();
        int n = chartDciConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            this.chart.addParameter(new GraphItem(dci.nodeId, dci.dciId, 0, 0, Long.toString(dci.dciId), dci.getName()), 0.0);
            int color = dci.getColorAsInt();
            if (color != -1) {
                this.chart.setPaletteEntry(index, new ChartColor(color));
            }
            ++index;
            ++n2;
        }
        this.chart.initializationComplete();
        this.startRefreshTimer();
    }

    @Override
    protected ChartDciConfig[] getDciList() {
        return this.config.getDciList();
    }
}

