/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views.helpers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TableItemComparator
extends ViewerComparator {
    private int[] dataTypes;

    public TableItemComparator(int[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int compare(Viewer viewer, Object e1, Object e2) {
        int n;
        int result;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        int format = column < this.dataTypes.length ? this.dataTypes[column] : 0;
        String value1 = (String)((List)e1).get(column);
        String value2 = (String)((List)e2).get(column);
        switch (format) {
            case 0: 
            case 4: 
            case 5: {
                result = value1.compareToIgnoreCase(value2);
                break;
            }
            case 1: {
                result = Long.signum(TableItemComparator.safeParseLong(value1) - TableItemComparator.safeParseLong(value2));
                break;
            }
            case 2: {
                result = (int)Math.signum(TableItemComparator.safeParseDouble(value1) - TableItemComparator.safeParseDouble(value2));
                break;
            }
            case 3: {
                try {
                    byte[] addr1 = InetAddress.getByName(value1).getAddress();
                    byte[] addr2 = InetAddress.getByName(value1).getAddress();
                    result = 0;
                    int i = 0;
                    while (i < addr1.length && result == 0) {
                        result = addr1[i] - addr2[i];
                        ++i;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    result = 0;
                }
                break;
            }
            default: {
                result = 0;
            }
        }
        if (((SortableTableViewer)viewer).getTable().getSortDirection() == 128) {
            n = result;
            return n;
        }
        n = -result;
        return n;
    }

    private static long safeParseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private static double safeParseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }
}

