/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.ColumnDefinition;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionObject;

public class DataCollectionTable
extends DataCollectionObject {
    private String instanceColumn;
    private List<ColumnDefinition> columns;

    public DataCollectionTable(DataCollectionConfiguration owner, NXCPMessage msg) {
        super(owner, msg);
        this.instanceColumn = msg.getVariableAsString(412L);
        int count2 = msg.getVariableAsInteger(166L);
        this.columns = new ArrayList<ColumnDefinition>(count2);
        long varId = 0x30000000L;
        for (int i = 0; i < count2; ++i) {
            this.columns.add(new ColumnDefinition(msg, varId));
            varId += 10L;
        }
    }

    public DataCollectionTable(DataCollectionConfiguration owner, long id) {
        super(owner, id);
        this.instanceColumn = null;
        this.columns = new ArrayList<ColumnDefinition>(0);
    }

    @Override
    public void fillMessage(NXCPMessage msg) {
        super.fillMessage(msg);
        msg.setVariableInt16(411L, 2);
        msg.setVariable(412L, this.instanceColumn);
        msg.setVariableInt32(166L, this.columns.size());
        long varId = 0x30000000L;
        for (int i = 0; i < this.columns.size(); ++i) {
            this.columns.get(i).fillMessage(msg, varId);
            varId += 10L;
        }
    }

    public String getInstanceColumn() {
        return this.instanceColumn;
    }

    public void setInstanceColumn(String instanceColumn) {
        this.instanceColumn = instanceColumn;
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnDefinition> columns) {
        this.columns = columns;
    }
}

