/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.TableColumnDefinition;

public class Table {
    private int source;
    private String title;
    private List<TableColumnDefinition> columns;
    private List<List<String>> data;

    public Table() {
        this.title = "untitled";
        this.source = 1;
        this.columns = new ArrayList<TableColumnDefinition>(0);
        this.data = new ArrayList<List<String>>(0);
    }

    public Table(NXCPMessage msg) {
        this.title = msg.getVariableAsString(168L);
        this.source = msg.getVariableAsInteger(46L);
        int columnCount = msg.getVariableAsInteger(329L);
        this.columns = new ArrayList<TableColumnDefinition>(columnCount);
        long varId = 0x10000000L;
        int i = 0;
        while (i < columnCount) {
            this.columns.add(new TableColumnDefinition(msg, varId));
            ++i;
            varId += 10L;
        }
        int totalRowCount = msg.getVariableAsInteger(328L);
        this.data = new ArrayList<List<String>>(totalRowCount);
        int rowCount = msg.getVariableAsInteger(167L);
        varId = 0x20000000L;
        for (int i2 = 0; i2 < rowCount; ++i2) {
            ArrayList<String> row = new ArrayList<String>(columnCount);
            for (int j = 0; j < columnCount; ++j) {
                row.add(msg.getVariableAsString(varId++));
            }
            this.data.add(row);
        }
    }

    public void addDataFromMessage(NXCPMessage msg) {
        int rowCount = msg.getVariableAsInteger(167L);
        long varId = 0x20000000L;
        for (int i = 0; i < rowCount; ++i) {
            ArrayList<String> row = new ArrayList<String>(this.columns.size());
            for (int j = 0; j < this.columns.size(); ++j) {
                row.add(msg.getVariableAsString(varId++));
            }
            this.data.add(row);
        }
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setVariable(168L, this.title);
        msg.setVariableInt32(329L, this.columns.size());
        long varId = 0x10000000L;
        for (TableColumnDefinition c : this.columns) {
            c.fillMessage(msg, varId);
            varId += 10L;
        }
        msg.setVariableInt32(328L, this.data.size());
        varId = 0x20000000L;
        for (int row = 0; row < this.data.size(); ++row) {
            List<String> rowData = this.data.get(row);
            for (int col = 0; col < rowData.size(); ++col) {
                msg.setVariable(varId++, rowData.get(col));
            }
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getRowCount() {
        return this.data.size();
    }

    public TableColumnDefinition getColumnDefinition(int column) throws IndexOutOfBoundsException {
        return this.columns.get(column);
    }

    public String getColumnName(int column) throws IndexOutOfBoundsException {
        return this.columns.get(column).getName();
    }

    public String getColumnDisplayName(int column) throws IndexOutOfBoundsException {
        return this.columns.get(column).getDisplayName();
    }

    @Deprecated
    public int getColumnFormat(int column) throws IndexOutOfBoundsException {
        return this.columns.get(column).getDataType();
    }

    public int getColumnIndex(String name) {
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!this.columns.get(i).getName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public TableColumnDefinition[] getColumns() {
        return this.columns.toArray(new TableColumnDefinition[this.columns.size()]);
    }

    public String getCell(int row, int column) throws IndexOutOfBoundsException {
        List<String> rowData = this.data.get(row);
        return rowData.get(column);
    }

    public List<String> getRow(int row) throws IndexOutOfBoundsException {
        return this.data.get(row);
    }

    public Object[] getAllRows() {
        Object[] rows = new Object[this.data.size()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = this.data.get(i);
        }
        return rows;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Table");
        sb.append("{columns=").append(this.columns);
        sb.append(", data=").append(this.data);
        sb.append('}');
        return sb.toString();
    }

    public void addAll(Table src) {
        this.data.addAll(src.data);
    }

    public void addRow() {
        ArrayList<String> row = new ArrayList<String>(this.columns.size());
        for (int i = 0; i < this.columns.size(); ++i) {
            row.add("");
        }
        this.data.add(row);
    }

    public void setCell(int row, int col, String value) {
        if (row >= 0 && row < this.data.size() && col >= 0 && col < this.columns.size()) {
            this.data.get(row).set(col, value);
        }
    }

    public int getSource() {
        return this.source;
    }

    public void setSource(int source) {
        this.source = source;
    }

    public String[] getColumnDisplayNames() {
        String[] names = new String[this.columns.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.columns.get(i).getDisplayName();
        }
        return names;
    }

    public int[] getColumnDataTypes() {
        int[] types = new int[this.columns.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.columns.get(i).getDataType();
        }
        return types;
    }
}

