/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.ColumnDefinition;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.TableThreshold;

public class DataCollectionTable
extends DataCollectionObject {
    private String instanceColumn;
    private List<ColumnDefinition> columns;
    private List<TableThreshold> thresholds;

    public DataCollectionTable(DataCollectionConfiguration owner, NXCPMessage msg) {
        super(owner, msg);
        int i;
        this.instanceColumn = msg.getVariableAsString(412L);
        int count = msg.getVariableAsInteger(166L);
        this.columns = new ArrayList<ColumnDefinition>(count);
        long varId = 0x30000000L;
        for (i = 0; i < count; ++i) {
            this.columns.add(new ColumnDefinition(msg, varId));
            varId += 10L;
        }
        count = msg.getVariableAsInteger(54L);
        this.thresholds = new ArrayList<TableThreshold>(count);
        varId = 0x20000000L;
        for (i = 0; i < count; ++i) {
            TableThreshold t = new TableThreshold(msg, varId);
            this.thresholds.add(t);
            varId = t.getNextVarId();
        }
    }

    public DataCollectionTable(DataCollectionConfiguration owner, long id) {
        super(owner, id);
        this.instanceColumn = null;
        this.columns = new ArrayList<ColumnDefinition>(0);
        this.thresholds = new ArrayList<TableThreshold>(0);
    }

    @Override
    public void fillMessage(NXCPMessage msg) {
        int i;
        super.fillMessage(msg);
        msg.setVariableInt16(411L, 2);
        msg.setVariable(412L, this.instanceColumn);
        msg.setVariableInt32(166L, this.columns.size());
        long varId = 0x30000000L;
        for (i = 0; i < this.columns.size(); ++i) {
            this.columns.get(i).fillMessage(msg, varId);
            varId += 10L;
        }
        msg.setVariableInt32(54L, this.thresholds.size());
        varId = 0x20000000L;
        for (i = 0; i < this.thresholds.size(); ++i) {
            varId = this.thresholds.get(i).fillMessage(msg, varId);
        }
    }

    public String getInstanceColumn() {
        return this.instanceColumn;
    }

    public void setInstanceColumn(String instanceColumn) {
        this.instanceColumn = instanceColumn;
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnDefinition> columns) {
        this.columns = columns;
    }

    public List<TableThreshold> getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(List<TableThreshold> thresholds) {
        this.thresholds = thresholds;
    }
}

