/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import org.netxms.base.NXCPMessage;

public class EventTemplate {
    public static final int FLAG_WRITE_TO_LOG = 1;
    private long code;
    private String name;
    private int severity;
    private int flags;
    private String message;
    private String description;

    public EventTemplate(long code) {
        this.code = code;
        this.name = "";
        this.severity = 0;
        this.flags = 1;
        this.message = "";
        this.description = "";
    }

    public EventTemplate(NXCPMessage msg) {
        this.code = msg.getVariableAsInt64(24L);
        this.severity = msg.getVariableAsInteger(25L);
        this.flags = msg.getVariableAsInteger(13L);
        this.name = msg.getVariableAsString(20L);
        this.message = msg.getVariableAsString(26L);
        this.description = msg.getVariableAsString(27L);
    }

    public EventTemplate(EventTemplate src) {
        this.setAll(src);
    }

    public void setAll(EventTemplate src) {
        this.code = src.code;
        this.severity = src.severity;
        this.flags = src.flags;
        this.name = src.name;
        this.message = src.message;
        this.description = src.description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getCode() {
        return this.code;
    }

    public void setCode(long code) {
        this.code = code;
    }
}

