/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import org.netxms.base.NXCPMessage;
import org.netxms.client.MacAddress;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.GenericObject;
import org.netxms.client.topology.RadioInterface;

public class AccessPoint
extends GenericObject {
    private long nodeId;
    private MacAddress macAddress;
    private String vendor;
    private String model;
    private String serialNumber;
    private RadioInterface[] radios;

    public AccessPoint(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.nodeId = msg.getVariableAsInt64(393L);
        this.macAddress = new MacAddress(msg.getVariableAsBinary(113L));
        this.vendor = msg.getVariableAsString(428L);
        this.model = msg.getVariableAsString(429L);
        this.serialNumber = msg.getVariableAsString(432L);
        int count = msg.getVariableAsInteger(442L);
        this.radios = new RadioInterface[count];
        long varId = 0x30000000L;
        for (int i = 0; i < count; ++i) {
            this.radios[i] = new RadioInterface(this, msg, varId);
            varId += 10L;
        }
    }

    @Override
    public String getObjectClassName() {
        return "AccessPoint";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getModel() {
        return this.model;
    }

    public RadioInterface[] getRadios() {
        return this.radios;
    }
}

