/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import org.netxms.base.NXCPMessage;
import org.netxms.client.MacAddress;
import org.netxms.client.objects.AccessPoint;

public class RadioInterface {
    private AccessPoint accessPoint;
    private int index;
    private String name;
    private MacAddress macAddress;
    private int channel;
    private int powerDBm;
    private int powerMW;

    public RadioInterface(AccessPoint ap, NXCPMessage msg, long baseId) {
        this.accessPoint = ap;
        this.index = msg.getVariableAsInteger(baseId);
        this.name = msg.getVariableAsString(baseId + 1L);
        this.macAddress = new MacAddress(msg.getVariableAsBinary(baseId + 2L));
        this.channel = msg.getVariableAsInteger(baseId + 3L);
        this.powerDBm = msg.getVariableAsInteger(baseId + 4L);
        this.powerMW = msg.getVariableAsInteger(baseId + 5L);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public MacAddress getMacAddress() {
        return this.macAddress;
    }

    public int getChannel() {
        return this.channel;
    }

    public int getPowerDBm() {
        return this.powerDBm;
    }

    public int getPowerMW() {
        return this.powerMW;
    }

    public AccessPoint getAccessPoint() {
        return this.accessPoint;
    }
}

