/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.api.client.reporting;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ReportRenderFormat {
    PDF(1, "pdf"),
    XLS(2, "xls");

    private final int code;
    private final String extension;
    private static final Map<Integer, ReportRenderFormat> lookupTable;

    private ReportRenderFormat(int code, String extenstion) {
        this.code = code;
        this.extension = extenstion;
    }

    public int getCode() {
        return this.code;
    }

    public static final ReportRenderFormat valueOf(Integer code) {
        return lookupTable.containsKey(code) ? lookupTable.get(code) : PDF;
    }

    public String getExtension() {
        return this.extension;
    }

    static {
        lookupTable = new HashMap<Integer, ReportRenderFormat>(2);
        for (ReportRenderFormat element : EnumSet.allOf(ReportRenderFormat.class)) {
            lookupTable.put(element.getCode(), element);
        }
    }
}

