/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ChildObjectListDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class RemoveClusterNode
implements IObjectActionDelegate {
    private Shell shell;
    private ViewPart viewPart;
    private long clusterId;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
        this.viewPart = targetPart instanceof ViewPart ? (ViewPart)targetPart : null;
    }

    public void run(IAction action) {
        final ChildObjectListDialog dlg = new ChildObjectListDialog(this.shell, this.clusterId, ChildObjectListDialog.createClassFilter((int)2));
        dlg.open();
        if (dlg.getReturnCode() == 0) {
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            new ConsoleJob("Remove cluster node", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.objectmanager", null){

                protected String getErrorMessage() {
                    return "Cannot remove node from cluster";
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    List objects = dlg.getSelectedObjects();
                    int i = 0;
                    while (i < objects.size()) {
                        session.removeClusterNode(RemoveClusterNode.this.clusterId, ((AbstractObject)objects.get(i)).getObjectId());
                        ++i;
                    }
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof Cluster) {
                action.setEnabled(true);
                this.clusterId = ((AbstractObject)obj).getObjectId();
            } else {
                action.setEnabled(false);
                this.clusterId = 0L;
            }
        } else {
            action.setEnabled(false);
            this.clusterId = 0L;
        }
    }
}

