/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.objectmanager.Activator;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateNetworkServiceDialog
extends Dialog {
    private LabeledText nameField;
    private Combo serviceTypeField;
    private LabeledText portField;
    private LabeledText requestField;
    private LabeledText responseField;
    private Button checkCreateDci;
    private String name;
    private int serviceType;
    private int port;
    private String request;
    private String response;
    private boolean createDci;

    public CreateNetworkServiceDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create Network Service Object");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel("Name");
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        this.nameField.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.serviceTypeField = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Service type", (Object)gd);
        this.serviceTypeField.add("User-defined");
        this.serviceTypeField.add("SSH");
        this.serviceTypeField.add("POP3");
        this.serviceTypeField.add("SMTP");
        this.serviceTypeField.add("FTP");
        this.serviceTypeField.add("HTTP");
        this.serviceTypeField.add("HTTPS");
        this.serviceTypeField.add("Telnet");
        this.serviceTypeField.select(0);
        this.portField = new LabeledText(dialogArea, 0);
        this.portField.setLabel("Port");
        this.portField.setText("0");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.portField.setLayoutData((Object)gd);
        this.requestField = new LabeledText(dialogArea, 0);
        this.requestField.setLabel("Request");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.requestField.setLayoutData((Object)gd);
        this.responseField = new LabeledText(dialogArea, 0);
        this.responseField.setLabel("Response");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.responseField.setLayoutData((Object)gd);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.checkCreateDci = new Button(dialogArea, 32);
        this.checkCreateDci.setText("&Create service status DCI at parent node");
        this.checkCreateDci.setSelection(settings.getBoolean("CreateNetworkServiceDialog.checkCreateDci"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.checkCreateDci.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.name = this.nameField.getText().trim();
        if (this.name.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please provide non-empty object name");
            return;
        }
        this.serviceType = this.serviceTypeField.getSelectionIndex();
        try {
            this.port = Integer.parseInt(this.portField.getText());
            if (this.port < 1 || this.port > 65535) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please enter valid port number (1 .. 65535)");
            return;
        }
        this.request = this.requestField.getText();
        this.response = this.responseField.getText();
        this.createDci = this.checkCreateDci.getSelection();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("CreateNetworkServiceDialog.checkCreateDci", this.createDci);
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public int getPort() {
        return this.port;
    }

    public String getRequest() {
        return this.request;
    }

    public String getResponse() {
        return this.response;
    }

    public boolean isCreateDci() {
        return this.createDci;
    }
}

