/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.propertypages;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.ui.eclipse.epp.Messages;
import org.netxms.ui.eclipse.epp.dialogs.AttributeEditDialog;
import org.netxms.ui.eclipse.epp.propertypages.helpers.AttributeLabelProvider;
import org.netxms.ui.eclipse.epp.widgets.RuleEditor;
import org.netxms.ui.eclipse.epp.widgets.SituationSelector;
import org.netxms.ui.eclipse.tools.ObjectLabelComparator;
import org.netxms.ui.eclipse.widgets.LabeledText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class RuleSituation
extends PropertyPage {
    private RuleEditor editor;
    private EventProcessingPolicyRule rule;
    private SituationSelector situation;
    private LabeledText instance;
    private SortableTableViewer viewer;
    private Map<String, String> attributes = new HashMap<String, String>();
    private Button addButton;
    private Button editButton;
    private Button deleteButton;

    protected Control createContents(Composite parent) {
        this.editor = (RuleEditor)((Object)this.getElement().getAdapter(RuleEditor.class));
        this.rule = this.editor.getRule();
        this.attributes.putAll(this.rule.getSituationAttributes());
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.situation = new SituationSelector(dialogArea, 0);
        this.situation.setLabel(Messages.RuleSituation_SituationObject);
        this.situation.setSituationId(this.rule.getSituationId());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.situation.setLayoutData(gd);
        this.instance = new LabeledText(dialogArea, 0);
        this.instance.setLabel(Messages.RuleSituation_Instance);
        this.instance.setText(this.rule.getSituationInstance());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalIndent = 2;
        this.instance.setLayoutData((Object)gd);
        Label label = new Label(dialogArea, 0);
        label.setText(Messages.RuleSituation_Attributes);
        gd = new GridData();
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        String[] columnNames = new String[]{Messages.RuleSituation_Name, Messages.RuleSituation_Value};
        int[] columnWidths = new int[]{150, 200};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.setInput((Object)this.attributes.entrySet().toArray());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)RuleSituation.this.viewer.getSelection()).size();
                RuleSituation.this.editButton.setEnabled(size == 1);
                RuleSituation.this.deleteButton.setEnabled(size > 0);
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(Messages.RuleSituation_Add);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RuleSituation.this.addAttribute();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(Messages.RuleSituation_Edit);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RuleSituation.this.editAttribute();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(Messages.RuleSituation_Delete);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                RuleSituation.this.deleteAttribute();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.setEnabled(false);
        return dialogArea;
    }

    private void addAttribute() {
        AttributeEditDialog dlg = new AttributeEditDialog(this.getShell(), null, null);
        if (dlg.open() == 0) {
            this.attributes.put(dlg.getAtributeName(), dlg.getAttributeValue());
            this.viewer.setInput((Object)this.attributes.entrySet().toArray());
        }
    }

    private void editAttribute() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry attr = (Map.Entry)selection.getFirstElement();
        AttributeEditDialog dlg = new AttributeEditDialog(this.getShell(), (String)attr.getKey(), (String)attr.getValue());
        if (dlg.open() == 0) {
            this.attributes.put(dlg.getAtributeName(), dlg.getAttributeValue());
            this.viewer.setInput((Object)this.attributes.entrySet().toArray());
        }
    }

    private void deleteAttribute() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                Map.Entry e = (Map.Entry)it.next();
                this.attributes.remove(e.getKey());
            }
            this.viewer.setInput((Object)this.attributes.entrySet().toArray());
        }
    }

    private void doApply() {
        this.rule.setSituationId(this.situation.getSituationId());
        this.rule.setSituationInstance(this.instance.getText());
        this.rule.setSituationAttributes(this.attributes);
        this.editor.setModified(true);
    }

    protected void performApply() {
        this.doApply();
    }

    public boolean performOk() {
        this.doApply();
        return super.performOk();
    }
}

