/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.dialogs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EnterIpAddressDlg
extends Dialog {
    private LabeledText ipAddressText;
    private ObjectSelector objectSelector;
    private InetAddress ipAddress;
    private long zoneId;
    private boolean zoningEnabled = ((NXCSession)ConsoleSharedData.getSession()).isZoningEnabled();

    public EnterIpAddressDlg(Shell parent) {
        super(parent);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Enter IP Address");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.ipAddressText = new LabeledText(dialogArea, 0);
        this.ipAddressText.setLabel("IP Address");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.ipAddressText.setLayoutData((Object)gd);
        if (this.zoningEnabled) {
            this.objectSelector = new ObjectSelector(dialogArea, 0, false);
            this.objectSelector.setLabel("Zone");
            this.objectSelector.setObjectClass(Zone.class);
            this.objectSelector.setClassFilter(ObjectSelectionDialog.createZoneSelectionFilter());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 300;
            this.objectSelector.setLayoutData((Object)gd);
        }
        return dialogArea;
    }

    protected void okPressed() {
        try {
            this.ipAddress = InetAddress.getByName(this.ipAddressText.getText());
        }
        catch (UnknownHostException unknownHostException) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please enter valid IP address!");
            return;
        }
        if (this.zoningEnabled) {
            long objectId = this.objectSelector.getObjectId();
            if (objectId == 0L) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select zone object!");
                return;
            }
            AbstractObject object = ((NXCSession)ConsoleSharedData.getSession()).findObjectById(objectId);
            if (object == null || !(object instanceof Zone)) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select zone object!");
                return;
            }
            this.zoneId = ((Zone)object).getZoneId();
        } else {
            this.zoneId = 0L;
        }
        super.okPressed();
    }

    public long getZoneId() {
        return this.zoneId;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }
}

