/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views;

import java.util.Iterator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.ui.eclipse.networkmaps.views.AbstractNetworkMapView;

public class ServiceDependency
extends AbstractNetworkMapView {
    public static final String ID = "org.netxms.ui.eclipse.networkmaps.views.ServiceDependency";

    @Override
    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.setPartName("Service Dependency - " + (this.rootObject != null ? this.rootObject.getObjectName() : "<error>"));
    }

    @Override
    protected void buildMapPage() {
        this.mapPage = new NetworkMapPage();
        long elementId = this.mapPage.createElementId();
        this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, this.rootObject.getObjectId()));
        this.addParentServices(this.rootObject, elementId);
    }

    private void addParentServices(AbstractObject object, long parentElementId) {
        Iterator it = object.getParents();
        while (it.hasNext()) {
            long objectId = (Long)it.next();
            AbstractObject parent = this.session.findObjectById(objectId);
            if (parent == null || !(parent instanceof Container) && !(parent instanceof Cluster)) continue;
            long elementId = this.mapPage.createElementId();
            this.mapPage.addElement((NetworkMapElement)new NetworkMapObject(elementId, objectId));
            this.mapPage.addLink(new NetworkMapLink(0, parentElementId, elementId));
            this.addParentServices(parent, elementId);
        }
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setLayoutAlgorithm(3, true);
    }
}

