/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ExtendedGraphViewer;

public class BendpointEditor {
    private static final int HANDLE_SIZE = 12;
    private NetworkMapLink linkObject;
    private GraphConnection connection;
    private Connection connectionFigure;
    private ExtendedGraphViewer viewer;
    private MouseListener mouseListener;
    private List<AbsoluteBendpoint> bendpoints = new ArrayList<AbsoluteBendpoint>(16);
    private Map<AbsoluteBendpoint, BendpointHandle> handles = new HashMap<AbsoluteBendpoint, BendpointHandle>(16);

    public BendpointEditor(NetworkMapLink linkObject, GraphConnection connection, ExtendedGraphViewer viewer) {
        this.linkObject = linkObject;
        this.connection = connection;
        this.connectionFigure = connection.getConnectionFigure();
        this.viewer = viewer;
        long[] points = linkObject.getBendPoints();
        if (points != null) {
            int i = 0;
            while (i < points.length) {
                if (points[i] == Integer.MAX_VALUE) break;
                AbsoluteBendpoint bp = new AbsoluteBendpoint((int)points[i], (int)points[i + 1]);
                this.bendpoints.add(bp);
                this.handles.put(bp, new BendpointHandle(bp));
                i += 2;
            }
            this.setRoutingConstraints();
        }
        this.mouseListener = new MouseListener(){

            public void mousePressed(MouseEvent me) {
            }

            public void mouseReleased(MouseEvent me) {
            }

            public void mouseDoubleClicked(MouseEvent me) {
                BendpointEditor.this.addBendPoint(me.x, me.y);
            }
        };
        this.connectionFigure.addMouseListener(this.mouseListener);
    }

    public void stop() {
        this.connectionFigure.removeMouseListener(this.mouseListener);
        this.saveBendPoints();
        this.setRoutingConstraints();
        for (BendpointHandle h : this.handles.values()) {
            if (h.getParent() == null) continue;
            h.getParent().remove((IFigure)h);
        }
    }

    private void saveBendPoints() {
        long[] points = new long[this.handles.size() * 2 + 2];
        int pos = 0;
        for (AbsoluteBendpoint bp : this.bendpoints) {
            points[pos++] = bp.x;
            points[pos++] = bp.y;
        }
        points[pos++] = Integer.MAX_VALUE;
        points[pos++] = Integer.MAX_VALUE;
        this.linkObject.setBendPoints(points);
    }

    private void setRoutingConstraints() {
        if (this.connection.isDisposed()) {
            return;
        }
        ConnectionRouter router = (ConnectionRouter)this.connection.getData("ROUTER");
        router.setConstraint(this.connectionFigure, this.bendpoints);
        this.connectionFigure.setRoutingConstraint(this.bendpoints);
    }

    private void addBendPoint(int x, int y) {
        if (this.bendpoints.size() >= 16) {
            return;
        }
        AbsoluteBendpoint bp = new AbsoluteBendpoint(x, y);
        if (this.bendpoints.size() > 1) {
            int index = 0;
            int i = 0;
            while (i < this.bendpoints.size() - 1) {
                AbsoluteBendpoint p1 = this.bendpoints.get(i);
                AbsoluteBendpoint p2 = this.bendpoints.get(i + 1);
                if (this.isLineContainsPoint(p1.x, p1.y, p2.x, p2.y, x, y)) {
                    index = i + 1;
                    break;
                }
                ++i;
            }
            if (index == 0) {
                Point pnode = this.connectionFigure.getTargetAnchor().getReferencePoint();
                AbsoluteBendpoint plast = this.bendpoints.get(this.bendpoints.size() - 1);
                if (this.isLineContainsPoint(pnode.x, pnode.y, plast.x, plast.y, x, y)) {
                    index = this.bendpoints.size();
                }
            }
            this.bendpoints.add(index, bp);
        } else if (this.bendpoints.size() == 1) {
            Point pnode = this.connectionFigure.getTargetAnchor().getReferencePoint();
            AbsoluteBendpoint plast = this.bendpoints.get(this.bendpoints.size() - 1);
            if (this.isLineContainsPoint(pnode.x, pnode.y, plast.x, plast.y, x, y)) {
                this.bendpoints.add(bp);
            } else {
                this.bendpoints.add(0, bp);
            }
        } else {
            this.bendpoints.add(bp);
        }
        this.setRoutingConstraints();
        this.handles.put(bp, new BendpointHandle(bp));
    }

    private boolean isLineContainsPoint(int x1, int y1, int x2, int y2, int px, int py) {
        int tolerance = 7;
        Rectangle rect = Rectangle.SINGLETON;
        rect.setSize(0, 0);
        rect.setLocation(x1, y1);
        rect.union(x2, y2);
        rect.expand(tolerance, tolerance);
        if (!rect.contains(px, py)) {
            return false;
        }
        double result = 0.0;
        if (x1 != x2 && y1 != y2) {
            int v1x = x2 - x1;
            int v1y = y2 - y1;
            int v2x = px - x1;
            int v2y = py - y1;
            int numerator = v2x * v1y - v1x * v2y;
            int denominator = v1x * v1x + v1y * v1y;
            result = (numerator << 10) / denominator * numerator >> 10;
        }
        return result <= (double)(tolerance * tolerance);
    }

    private class BendpointHandle
    extends RoundedRectangle
    implements MouseListener,
    MouseMotionListener {
        private AbsoluteBendpoint bp;
        private boolean drag = false;

        BendpointHandle(AbsoluteBendpoint bp) {
            this.bp = bp;
            this.setSize(12, 12);
            BendpointEditor.this.connectionFigure.getParent().add((IFigure)this);
            this.setLocation(new Point(bp.x - 6, bp.y - 6));
            this.addMouseListener(this);
            this.setCursor(Display.getCurrent().getSystemCursor(2));
        }

        private void stopDragging() {
            BendpointEditor.this.viewer.hideCrosshair();
            this.removeMouseMotionListener(this);
            this.drag = false;
            BendpointEditor.this.setRoutingConstraints();
            BendpointEditor.this.saveBendPoints();
        }

        public void mousePressed(MouseEvent me) {
            if (me.button == 1) {
                if ((me.getState() & 0x40000) != 0) {
                    BendpointEditor.this.bendpoints.remove(this.bp);
                    BendpointEditor.this.handles.remove(this.bp);
                    this.getParent().remove((IFigure)this);
                    BendpointEditor.this.setRoutingConstraints();
                    BendpointEditor.this.saveBendPoints();
                } else {
                    this.addMouseMotionListener(this);
                    this.drag = true;
                    BendpointEditor.this.viewer.showCrosshair(me.x, me.y);
                }
                me.consume();
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (me.button == 1 && this.drag) {
                this.bp.x = me.x;
                this.bp.y = me.y;
                this.stopDragging();
            }
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent me) {
            if (this.drag) {
                BendpointEditor.this.viewer.showCrosshair(me.x, me.y);
                this.setLocation(new Point(me.x - 6, me.y - 6));
                me.consume();
            }
        }

        public void mouseEntered(MouseEvent me) {
        }

        public void mouseExited(MouseEvent me) {
            if (this.drag) {
                this.stopDragging();
            }
        }

        public void mouseHover(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
        }
    }
}

