/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.ChartConfig;
import org.netxms.ui.eclipse.perfview.PredefinedChartConfig;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetFactory;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.DateTimeSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class General
extends PropertyPage {
    private ChartConfig config;
    private LabeledText title;
    private Button checkShowGrid;
    private Button checkShowLegend;
    private Button checkAutoScale;
    private Button checkShowHostNames;
    private Button checkShowRuler;
    private Button checkEnableZoom;
    private Button checkAutoRefresh;
    private Button checkLogScale;
    private Scale refreshIntervalScale;
    private Spinner refreshIntervalSpinner;
    private Button radioBackFromNow;
    private Button radioFixedInterval;
    private Spinner timeRange;
    private Combo timeUnits;
    private DateTimeSelector timeFrom;
    private DateTimeSelector timeTo;

    protected Control createContents(Composite parent) {
        this.config = (ChartConfig)this.getElement().getAdapter(ChartConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.title = new LabeledText(dialogArea, 0, 2048);
        this.title.setLabel("Title");
        this.title.setText(this.config.getTitle());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText("Options");
        layout = new GridLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        layout.verticalSpacing = 4;
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 2;
        optionsGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        this.checkShowGrid = new Button((Composite)optionsGroup, 32);
        this.checkShowGrid.setText("Show &grid lines");
        this.checkShowGrid.setSelection(this.config.isShowGrid());
        this.checkAutoScale = new Button((Composite)optionsGroup, 32);
        this.checkAutoScale.setText("&Autoscale");
        this.checkShowLegend = new Button((Composite)optionsGroup, 32);
        this.checkShowLegend.setText("Show &legend");
        this.checkShowLegend.setSelection(this.config.isShowLegend());
        this.checkShowRuler = new Button((Composite)optionsGroup, 32);
        this.checkShowRuler.setText("Show &ruler");
        this.checkShowRuler.setSelection(false);
        this.checkShowHostNames = new Button((Composite)optionsGroup, 32);
        this.checkShowHostNames.setText("Show &host names");
        this.checkShowHostNames.setSelection(this.config.isShowHostNames());
        this.checkEnableZoom = new Button((Composite)optionsGroup, 32);
        this.checkEnableZoom.setText("Enable &zoom");
        this.checkEnableZoom.setSelection(false);
        this.checkAutoRefresh = new Button((Composite)optionsGroup, 32);
        this.checkAutoRefresh.setText("&Refresh automatically");
        this.checkAutoRefresh.setSelection(this.config.isAutoRefresh());
        this.checkLogScale = new Button((Composite)optionsGroup, 32);
        this.checkLogScale.setText("L&ogaritmic scale");
        this.checkLogScale.setSelection(this.config.isLogScale());
        Composite refreshIntervalGroup = new Composite((Composite)optionsGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        refreshIntervalGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        refreshIntervalGroup.setLayoutData((Object)gd);
        Label label = new Label(refreshIntervalGroup, 0);
        label.setText("Refresh interval:");
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.refreshIntervalScale = new Scale(refreshIntervalGroup, 256);
        this.refreshIntervalScale.setMinimum(1);
        this.refreshIntervalScale.setMaximum(600);
        this.refreshIntervalScale.setSelection(this.config.getRefreshRate());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshIntervalScale.setLayoutData((Object)gd);
        this.refreshIntervalScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.refreshIntervalSpinner.setSelection(General.this.refreshIntervalScale.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.refreshIntervalSpinner = new Spinner(refreshIntervalGroup, 2048);
        this.refreshIntervalSpinner.setMinimum(1);
        this.refreshIntervalSpinner.setMaximum(600);
        this.refreshIntervalSpinner.setSelection(this.config.getRefreshRate());
        this.refreshIntervalSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.refreshIntervalScale.setSelection(General.this.refreshIntervalSpinner.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Group timeGroup = new Group(dialogArea, 0);
        timeGroup.setText("Time Period");
        layout = new GridLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        layout.horizontalSpacing = 16;
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 2;
        timeGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        timeGroup.setLayoutData((Object)gd);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.timeRange.setEnabled(General.this.radioBackFromNow.getSelection());
                General.this.timeUnits.setEnabled(General.this.radioBackFromNow.getSelection());
                General.this.timeFrom.setEnabled(General.this.radioFixedInterval.getSelection());
                General.this.timeTo.setEnabled(General.this.radioFixedInterval.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioBackFromNow = new Button((Composite)timeGroup, 16);
        this.radioBackFromNow.setText("&Back from now");
        this.radioBackFromNow.setSelection(this.config.getTimeFrameType() == 1);
        this.radioBackFromNow.addSelectionListener(listener);
        this.radioFixedInterval = new Button((Composite)timeGroup, 16);
        this.radioFixedInterval.setText("&Fixed time frame");
        this.radioFixedInterval.setSelection(this.config.getTimeFrameType() == 0);
        this.radioFixedInterval.addSelectionListener(listener);
        Composite timeBackGroup = new Composite((Composite)timeGroup, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        timeBackGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        timeBackGroup.setLayoutData((Object)gd);
        this.timeRange = WidgetHelper.createLabeledSpinner((Composite)timeBackGroup, (int)2048, (String)"Time interval", (int)1, (int)10000, (Object)"WidgetHelper::default_layout_data");
        this.timeRange.setSelection(this.config.getTimeRange());
        this.timeRange.setEnabled(this.radioBackFromNow.getSelection());
        this.timeUnits = WidgetHelper.createLabeledCombo((Composite)timeBackGroup, (int)8, (String)"Time units", (Object)"WidgetHelper::default_layout_data");
        this.timeUnits.add("Minutes");
        this.timeUnits.add("Hours");
        this.timeUnits.add("Days");
        this.timeUnits.select(this.config.getTimeUnits());
        this.timeUnits.setEnabled(this.radioBackFromNow.getSelection());
        Composite timeFixedGroup = new Composite((Composite)timeGroup, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 4;
        timeFixedGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        timeFixedGroup.setLayoutData((Object)gd);
        WidgetFactory factory = new WidgetFactory(){

            public Control createControl(Composite parent, int style) {
                return new DateTimeSelector(parent, style);
            }
        };
        this.timeFrom = (DateTimeSelector)WidgetHelper.createLabeledControl((Composite)timeFixedGroup, (int)0, (WidgetFactory)factory, (String)"Time from", (Object)"WidgetHelper::default_layout_data");
        this.timeFrom.setValue(this.config.getTimeFrom());
        this.timeFrom.setEnabled(this.radioFixedInterval.getSelection());
        this.timeTo = (DateTimeSelector)WidgetHelper.createLabeledControl((Composite)timeFixedGroup, (int)0, (WidgetFactory)factory, (String)"Time to", (Object)"WidgetHelper::default_layout_data");
        this.timeTo.setValue(this.config.getTimeTo());
        this.timeTo.setEnabled(this.radioFixedInterval.getSelection());
        return dialogArea;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.title.setText("");
        this.checkShowGrid.setSelection(true);
        this.checkShowLegend.setSelection(true);
        this.checkAutoScale.setSelection(true);
        this.checkShowHostNames.setSelection(false);
        this.checkShowRuler.setSelection(false);
        this.checkEnableZoom.setSelection(true);
        this.checkAutoRefresh.setSelection(true);
        this.checkLogScale.setSelection(false);
        this.refreshIntervalScale.setSelection(30);
        this.refreshIntervalSpinner.setSelection(30);
        this.radioBackFromNow.setSelection(true);
        this.radioFixedInterval.setSelection(false);
        this.timeRange.setSelection(60);
        this.timeRange.setEnabled(true);
        this.timeUnits.select(0);
        this.timeUnits.setEnabled(true);
        this.timeFrom.setEnabled(false);
        this.timeTo.setEnabled(false);
    }

    protected void applyChanges(boolean isApply) {
        this.config.setTitle(this.title.getText());
        this.config.setShowGrid(this.checkShowGrid.getSelection());
        this.config.setShowLegend(this.checkShowLegend.getSelection());
        this.config.setShowHostNames(this.checkShowHostNames.getSelection());
        this.config.setAutoRefresh(this.checkAutoRefresh.getSelection());
        this.config.setLogScale(this.checkLogScale.getSelection());
        this.config.setRefreshRate(this.refreshIntervalSpinner.getSelection());
        this.config.setTimeFrameType(this.radioBackFromNow.getSelection() ? 1 : 0);
        this.config.setTimeUnits(this.timeUnits.getSelectionIndex());
        this.config.setTimeRange(this.timeRange.getSelection());
        this.config.setTimeFrom(this.timeFrom.getValue());
        this.config.setTimeTo(this.timeTo.getValue());
        if (this.config instanceof PredefinedChartConfig && isApply) {
            this.setValid(false);
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            new ConsoleJob("Update predefined graph", null, "org.netxms.ui.eclipse.perfview", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    session.modifyPredefinedGraph(((PredefinedChartConfig)General.this.config).createServerSettings());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            General.this.setValid(true);
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Cannot update predefined graph";
                }
            }.start();
        }
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

