/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;

public class SummaryTablesCache {
    private static Map<Integer, DciSummaryTableDescriptor> tables = new HashMap<Integer, DciSummaryTableDescriptor>();
    private static NXCSession session = null;

    public static void init(NXCSession session) {
        SummaryTablesCache.session = session;
        SummaryTablesCache.reload();
        session.addListener(new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                switch (n.getCode()) {
                    case 1021: {
                        SummaryTablesCache.onTableChange((int)n.getSubCode());
                        break;
                    }
                    case 1022: {
                        SummaryTablesCache.onTableDelete((int)n.getSubCode());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reload() {
        try {
            List list = session.listDciSummaryTables();
            Map<Integer, DciSummaryTableDescriptor> map = tables;
            synchronized (map) {
                tables.clear();
                for (DciSummaryTableDescriptor d : list) {
                    tables.put(d.getId(), d);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void onTableChange(int tableId) {
        new Thread(){

            @Override
            public void run() {
                SummaryTablesCache.reload();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onTableDelete(int tableId) {
        Map<Integer, DciSummaryTableDescriptor> map = tables;
        synchronized (map) {
            tables.remove(tableId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DciSummaryTableDescriptor[] getTables() {
        DciSummaryTableDescriptor[] t = null;
        Map<Integer, DciSummaryTableDescriptor> map = tables;
        synchronized (map) {
            t = tables.values().toArray(new DciSummaryTableDescriptor[tables.values().size()]);
        }
        return t;
    }
}

