/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.dialogs;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.BrandingManager;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class LoginDialog
extends Dialog {
    private ImageDescriptor loginImage = BrandingManager.getInstance().getLoginTitleImage();
    private Button checkBoxEncrypt;
    private Button checkBoxDontCache;
    private Button checkBoxClearCache;
    private Button checkBoxMatchVersion;
    private Combo comboServer;
    private Text textLogin;
    private Text textPassword;
    private String password;
    private boolean isOk = false;
    private Color labelColor;

    public LoginDialog(Shell parentShell) {
        super(parentShell);
        if (this.loginImage == null) {
            this.loginImage = Activator.getImageDescriptor("icons/login.png");
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        String customTitle = BrandingManager.getInstance().getLoginTitle();
        newShell.setText(customTitle != null ? customTitle : Messages.LoginDialog_title);
        Monitor[] ma = newShell.getDisplay().getMonitors();
        if (ma != null) {
            newShell.setLocation((ma[0].getClientArea().width - newShell.getSize().x) / 2, (ma[0].getClientArea().height - newShell.getSize().y) / 2);
        }
    }

    protected Control createDialogArea(Composite parent) {
        String text;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.numColumns = 2;
        dialogLayout.marginWidth = 10;
        dialogLayout.marginHeight = 10;
        dialogLayout.horizontalSpacing = 0;
        dialogArea.setLayout((Layout)dialogLayout);
        RGB customColor = BrandingManager.getInstance().getLoginTitleColor();
        this.labelColor = customColor != null ? new Color((Device)dialogArea.getDisplay(), customColor) : new Color((Device)dialogArea.getDisplay(), 36, 66, 90);
        dialogArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LoginDialog.this.labelColor.dispose();
            }
        });
        Label label = new Label(dialogArea, 0);
        label.setBackground(this.labelColor);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gd);
        label = new Label(dialogArea, 0);
        label.setImage(this.loginImage.createImage());
        label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                ((Label)event.widget).getImage().dispose();
            }
        });
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        label.setLayoutData((Object)gd);
        Composite fields = new Composite(dialogArea, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        fields.setLayout((Layout)formLayout);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        fields.setLayoutData((Object)gd);
        Group groupConn = new Group(fields, 16);
        groupConn.setText(Messages.LoginDialog_connection);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        groupConn.setLayout((Layout)gridLayout);
        label = new Label((Composite)groupConn, 0);
        label.setText(Messages.LoginDialog_server);
        this.comboServer = new Combo((Composite)groupConn, 4);
        String[] items = settings.getArray("Connect.ServerHistory");
        if (items != null) {
            this.comboServer.setItems(items);
        }
        if ((text = settings.get("Connect.Server")) != null) {
            this.comboServer.setText(text);
        }
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.comboServer.setLayoutData((Object)gridData);
        label = new Label((Composite)groupConn, 0);
        label.setText(Messages.LoginDialog_login);
        this.textLogin = new Text((Composite)groupConn, 2052);
        text = settings.get("Connect.Login");
        if (text != null) {
            this.textLogin.setText(text);
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = WidgetHelper.getTextWidth((Control)this.textLogin, "M") * 16;
        this.textLogin.setLayoutData((Object)gridData);
        label = new Label((Composite)groupConn, 0);
        label.setText(Messages.LoginDialog_password);
        this.textPassword = new Text((Composite)groupConn, 0x400804);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.textPassword.setLayoutData((Object)gridData);
        Group groupOpts = new Group(fields, 16);
        groupOpts.setText(Messages.LoginDialog_options);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.spacing = 4;
        groupOpts.setLayout((Layout)rowLayout);
        this.checkBoxEncrypt = new Button((Composite)groupOpts, 32);
        this.checkBoxEncrypt.setText(Messages.LoginDialog_opt_encrypt);
        boolean encrypt = true;
        if (settings.get("Connect.Encrypt") != null) {
            encrypt = settings.getBoolean("Connect.Encrypt");
        }
        this.checkBoxEncrypt.setSelection(encrypt);
        this.checkBoxClearCache = new Button((Composite)groupOpts, 32);
        this.checkBoxClearCache.setText(Messages.LoginDialog_opt_clear_cache);
        this.checkBoxClearCache.setSelection(settings.getBoolean("Connect.ClearCache"));
        this.checkBoxDontCache = new Button((Composite)groupOpts, 32);
        this.checkBoxDontCache.setText(Messages.LoginDialog_opt_dont_cache);
        this.checkBoxDontCache.setSelection(settings.getBoolean("Connect.DontCache"));
        this.checkBoxMatchVersion = new Button((Composite)groupOpts, 32);
        this.checkBoxMatchVersion.setText(Messages.LoginDialog_opt_version_match);
        this.checkBoxMatchVersion.setSelection(settings.getBoolean("Connect.MatchVersion"));
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment((Control)groupOpts, 0, 16384);
        fd.bottom = new FormAttachment(100, 0);
        groupConn.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        groupOpts.setLayoutData((Object)fd);
        if (this.comboServer.getText().isEmpty()) {
            this.comboServer.setFocus();
        } else if (this.textLogin.getText().isEmpty()) {
            this.textLogin.setFocus();
        } else {
            this.textPassword.setFocus();
        }
        return dialogArea;
    }

    protected void okPressed() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        HashSet<String> items = new HashSet<String>();
        items.addAll(Arrays.asList(this.comboServer.getItems()));
        items.add(this.comboServer.getText());
        settings.put("Connect.Server", this.comboServer.getText());
        settings.put("Connect.ServerHistory", items.toArray(new String[items.size()]));
        settings.put("Connect.Login", this.textLogin.getText());
        settings.put("Connect.Encrypt", this.checkBoxEncrypt.getSelection());
        settings.put("Connect.DontCache", this.checkBoxDontCache.getSelection());
        settings.put("Connect.ClearCache", this.checkBoxClearCache.getSelection());
        settings.put("Connect.MatchVersion", this.checkBoxMatchVersion.getSelection());
        this.password = this.textPassword.getText();
        this.isOk = true;
        super.okPressed();
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isOk() {
        return this.isOk;
    }
}

