/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.tools;

import java.util.HashMap;
import java.util.Map;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.tools.Command;

public final class CommandBridge {
    private static CommandBridge instance = new CommandBridge();
    private Map<String, Command> commands = new HashMap<String, Command>();

    public static CommandBridge getInstance() {
        return instance;
    }

    private CommandBridge() {
    }

    public void registerCommand(String name, Command cmd) {
        this.commands.put(name, cmd);
    }

    public void unregisterCommand(String name) {
        this.commands.remove(name);
    }

    public Object execute(String name, Object arg) {
        try {
            Command c = this.commands.get(name);
            return c != null ? c.execute(name, arg) : null;
        }
        catch (Exception e) {
            Activator.logError("Exception while calling handler for bridged command " + name, e);
            return null;
        }
    }
}

