/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.Threshold;
import org.netxms.ui.eclipse.charts.Activator;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.Gauge;
import org.netxms.ui.eclipse.charts.widgets.GenericChart;
import org.netxms.ui.eclipse.charts.widgets.internal.DataComparisonElement;
import org.netxms.ui.eclipse.tools.ColorCache;

public abstract class GaugeWidget
extends GenericChart
implements Gauge,
PaintListener,
DisposeListener {
    protected static final int OUTER_MARGIN_WIDTH = 5;
    protected static final int OUTER_MARGIN_HEIGHT = 5;
    protected static final int INNER_MARGIN_WIDTH = 5;
    protected static final int INNER_MARGIN_HEIGHT = 5;
    protected static final RGB GREEN_ZONE_COLOR = new RGB(0, 224, 0);
    protected static final RGB YELLOW_ZONE_COLOR = new RGB(255, 242, 0);
    protected static final RGB RED_ZONE_COLOR = new RGB(224, 0, 0);
    protected List<DataComparisonElement> parameters = new ArrayList<DataComparisonElement>(16);
    protected Image chartImage = null;
    protected ColorCache colors = new ColorCache((Control)this);
    protected double minValue = 0.0;
    protected double maxValue = 100.0;
    protected double leftRedZone = 0.0;
    protected double leftYellowZone = 0.0;
    protected double rightYellowZone = 70.0;
    protected double rightRedZone = 90.0;
    protected boolean vertical = false;
    protected boolean legendInside = true;
    protected boolean gridVisible = true;
    protected String fontName = "Verdana";
    private boolean fontsCreated = false;

    public GaugeWidget(Composite parent, int style) {
        super(parent, style | 0x40000);
        this.addPaintListener(this);
        this.addDisposeListener(this);
        this.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                if (GaugeWidget.this.chartImage != null) {
                    GaugeWidget.this.chartImage.dispose();
                    GaugeWidget.this.chartImage = null;
                }
                GaugeWidget.this.refresh();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    protected abstract void createFonts();

    protected abstract void disposeFonts();

    @Override
    public void initializationComplete() {
    }

    protected Color getColorFromPreferences(String name) {
        return this.colors.create(PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)name));
    }

    @Override
    public void setChartTitle(String title) {
        this.title = title;
        this.refresh();
    }

    @Override
    public void setTitleVisible(boolean visible) {
        this.titleVisible = visible;
        this.refresh();
    }

    @Override
    public void setLegendVisible(boolean visible) {
        this.legendVisible = visible;
        this.refresh();
    }

    @Override
    public void set3DModeEnabled(boolean enabled) {
        this.displayIn3D = enabled;
        this.refresh();
    }

    @Override
    public void setLogScaleEnabled(boolean enabled) {
    }

    @Override
    public int addParameter(GraphItem dci, double value) {
        this.parameters.add(new DataComparisonElement(dci, value));
        return this.parameters.size() - 1;
    }

    @Override
    public void updateParameter(int index, double value, boolean updateChart) {
        try {
            this.parameters.get(index).setValue(value);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        if (updateChart) {
            this.refresh();
        }
    }

    @Override
    public void updateParameterThresholds(int index, Threshold[] thresholds) {
    }

    @Override
    public void setChartType(int chartType) {
    }

    @Override
    public int getChartType() {
        return 4;
    }

    @Override
    public void setTransposed(boolean transposed) {
    }

    @Override
    public boolean isTransposed() {
        return false;
    }

    @Override
    public void setLabelsVisible(boolean visible) {
    }

    @Override
    public boolean isLabelsVisible() {
        return false;
    }

    @Override
    public void setRotation(double angle) {
    }

    @Override
    public double getRotation() {
        return 0.0;
    }

    @Override
    public void refresh() {
        this.render();
        this.redraw();
    }

    @Override
    public void rebuild() {
        this.render();
        this.redraw();
    }

    @Override
    public boolean hasAxes() {
        return false;
    }

    public void paintControl(PaintEvent e) {
        if (this.chartImage != null) {
            e.gc.drawImage(this.chartImage, 0, 0);
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        if (this.chartImage != null) {
            this.chartImage.dispose();
        }
        this.disposeFonts();
    }

    private void render() {
        int h;
        if (!this.fontsCreated) {
            this.createFonts();
            this.fontsCreated = true;
        }
        Point size = this.getSize();
        if (this.chartImage == null) {
            if (size.x <= 0 || size.y <= 0) {
                return;
            }
            this.chartImage = new Image((Device)this.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.chartImage);
        gc.setBackground(this.getColorFromPreferences("Chart.Colors.Background"));
        gc.fillRectangle(0, 0, size.x, size.y);
        gc.setAntialias(1);
        gc.setTextAntialias(1);
        int top = 5;
        if (this.titleVisible && this.title != null) {
            gc.setFont(Activator.getDefault().getChartTitleFont());
            gc.setForeground(this.getColorFromPreferences("Chart.Colors.Title"));
            Point ext = gc.textExtent(this.title, 1);
            int x = ext.x < size.x ? (size.x - ext.x) / 2 : 0;
            gc.drawText(this.title, x, top, true);
            top += ext.y + 5;
        }
        if (this.parameters.size() == 0 || size.x < 10 || size.y < 10) {
            gc.dispose();
            return;
        }
        if (this.vertical) {
            int w = size.x - 10;
            h = (size.y - 5 - top) / this.parameters.size();
            if (w > 40 && h > 40 * this.parameters.size()) {
                int i = 0;
                while (i < this.parameters.size()) {
                    this.renderElement(gc, this.parameters.get(i), 0, top + i * h, w, h);
                    ++i;
                }
            }
        } else {
            int w = (size.x - 10) / this.parameters.size();
            h = size.y - 5 - top;
            if (w > 40 * this.parameters.size() && h > 40) {
                int i = 0;
                while (i < this.parameters.size()) {
                    this.renderElement(gc, this.parameters.get(i), i * w, top, w, h);
                    ++i;
                }
            }
        }
        gc.dispose();
    }

    protected abstract void renderElement(GC var1, DataComparisonElement var2, int var3, int var4, int var5, int var6);

    protected String getValueAsDisplayString(DataComparisonElement dci) {
        switch (dci.getObject().getDataType()) {
            case 0: {
                return Integer.toString((int)dci.getValue());
            }
            case 1: 
            case 2: 
            case 3: {
                return Long.toString((long)dci.getValue());
            }
        }
        return Double.toString(dci.getValue());
    }

    @Override
    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    @Override
    public double getLeftRedZone() {
        return this.leftRedZone;
    }

    @Override
    public void setLeftRedZone(double leftRedZone) {
        this.leftRedZone = leftRedZone;
    }

    @Override
    public double getLeftYellowZone() {
        return this.leftYellowZone;
    }

    @Override
    public void setLeftYellowZone(double leftYellowZone) {
        this.leftYellowZone = leftYellowZone;
    }

    @Override
    public double getRightYellowZone() {
        return this.rightYellowZone;
    }

    @Override
    public void setRightYellowZone(double rightYellowZone) {
        this.rightYellowZone = rightYellowZone;
    }

    @Override
    public double getRightRedZone() {
        return this.rightRedZone;
    }

    @Override
    public void setRightRedZone(double rightRedZone) {
        this.rightRedZone = rightRedZone;
    }

    @Override
    public boolean isLegendInside() {
        return this.legendInside;
    }

    @Override
    public void setLegendInside(boolean legendInside) {
        this.legendInside = legendInside;
    }

    @Override
    public boolean isGridVisible() {
        return this.gridVisible;
    }

    @Override
    public void setGridVisible(boolean visible) {
        this.gridVisible = visible;
    }

    @Override
    public void setBackgroundColor(ChartColor color) {
    }

    @Override
    public void setPlotAreaColor(ChartColor color) {
    }

    @Override
    public void setLegendColor(ChartColor foreground, ChartColor background) {
    }

    @Override
    public void setAxisColor(ChartColor color) {
    }

    @Override
    public void setGridColor(ChartColor color) {
    }

    @Override
    public void addError(String message) {
    }

    @Override
    public void clearErrors() {
    }

    @Override
    public boolean isVertical() {
        return this.vertical;
    }

    @Override
    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public void setFontName(String fontName) {
        if (fontName == null || fontName.isEmpty()) {
            fontName = "Verdana";
        }
        if (!fontName.equals(this.fontName)) {
            this.fontName = fontName;
            if (this.fontsCreated) {
                this.disposeFonts();
            }
            this.createFonts();
            this.fontsCreated = true;
        }
    }
}

