/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementLayout;

public class DashboardElementsLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String[] ELEMENT_TYPES = new String[]{Messages.DashboardElementsLabelProvider_TypeLabel, Messages.DashboardElementsLabelProvider_TypeLineChart, Messages.DashboardElementsLabelProvider_TypeBarChart, Messages.DashboardElementsLabelProvider_TypePieChart, Messages.DashboardElementsLabelProvider_TypeTubeChart, Messages.DashboardElementsLabelProvider_TypeStatusChart, Messages.DashboardElementsLabelProvider_TypeStatusIndicator, Messages.DashboardElementsLabelProvider_TypeDashboard, Messages.DashboardElementsLabelProvider_TypeNetworkMap, Messages.DashboardElementsLabelProvider_TypeCustom, Messages.DashboardElementsLabelProvider_TypeGeoMap, Messages.DashboardElementsLabelProvider_TypeAlarmViewer, Messages.DashboardElementsLabelProvider_TypeAvailChart, Messages.DashboardElementsLabelProvider_TypeGaugeChart, Messages.DashboardElementsLabelProvider_TypeWebPage, Messages.DashboardElementsLabelProvider_TypeTableBarChart, Messages.DashboardElementsLabelProvider_TypeTablePieChart, Messages.DashboardElementsLabelProvider_TypeTableTubeChart, Messages.DashboardElementsLabelProvider_TypeSeparator, "Table Value", "Status Map"};
    private static final String[] H_ALIGH = new String[]{Messages.DashboardElementsLabelProvider_Fill, Messages.DashboardElementsLabelProvider_Center, Messages.DashboardElementsLabelProvider_Left, Messages.DashboardElementsLabelProvider_Right};
    private static final String[] V_ALIGH = new String[]{Messages.DashboardElementsLabelProvider_Fill, Messages.DashboardElementsLabelProvider_Center, Messages.DashboardElementsLabelProvider_Top, Messages.DashboardElementsLabelProvider_Bottom};

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DashboardElement de = (DashboardElement)element;
        switch (columnIndex) {
            case 0: {
                try {
                    return ELEMENT_TYPES[de.getType()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return Messages.DashboardElementsLabelProvider_Unknown;
                }
            }
            case 1: {
                try {
                    DashboardElementLayout layout = DashboardElementLayout.createFromXml(de.getLayout());
                    return String.valueOf(Integer.toString(layout.horizontalSpan)) + " / " + Integer.toString(layout.verticalSpan);
                }
                catch (Exception exception) {
                    return "1 / 1";
                }
            }
            case 2: {
                try {
                    DashboardElementLayout layout = DashboardElementLayout.createFromXml(de.getLayout());
                    try {
                        return String.valueOf(H_ALIGH[layout.horizontalAlignment]) + " / " + V_ALIGH[layout.vertcalAlignment];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return Messages.DashboardElementsLabelProvider_Unknown;
                    }
                }
                catch (Exception exception) {
                    return Messages.DashboardElementsLabelProvider_FillFill;
                }
            }
        }
        return null;
    }
}

