/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.base.GeoLocation;
import org.netxms.base.GeoLocationFormatException;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class Location
extends PropertyPage {
    private AbstractObject object;
    private LabeledText latitude;
    private LabeledText longitude;
    private Button radioTypeUndefined;
    private Button radioTypeManual;
    private Button radioTypeAuto;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        GeoLocation gl = this.object.getGeolocation();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group typeGroup = new Group(dialogArea, 0);
        typeGroup.setText("Location type");
        GridData gd = new GridData();
        gd.verticalSpan = 2;
        typeGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        typeGroup.setLayout((Layout)layout);
        this.radioTypeUndefined = new Button((Composite)typeGroup, 16);
        this.radioTypeUndefined.setText("&Undefined");
        this.radioTypeUndefined.setSelection(gl.getType() == 0);
        this.radioTypeManual = new Button((Composite)typeGroup, 16);
        this.radioTypeManual.setText("&Manual");
        this.radioTypeManual.setSelection(gl.getType() == 1);
        this.radioTypeAuto = new Button((Composite)typeGroup, 16);
        this.radioTypeAuto.setText("&Automatic from GPS receiver");
        this.radioTypeAuto.setSelection(gl.getType() == 2);
        this.latitude = new LabeledText(dialogArea, 0);
        this.latitude.setLabel("Latitude");
        if (gl.getType() != 0) {
            this.latitude.setText(gl.getLatitudeAsString());
        }
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.latitude.setLayoutData((Object)gd);
        this.latitude.setEnabled(gl.getType() == 1);
        this.longitude = new LabeledText(dialogArea, 0);
        this.longitude.setLabel("Longitude");
        if (gl.getType() != 0) {
            this.longitude.setText(gl.getLongitudeAsString());
        }
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.longitude.setLayoutData((Object)gd);
        this.longitude.setEnabled(gl.getType() == 1);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Location.this.latitude.setEnabled(Location.this.radioTypeManual.getSelection());
                Location.this.longitude.setEnabled(Location.this.radioTypeManual.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioTypeUndefined.addSelectionListener(listener);
        this.radioTypeManual.addSelectionListener(listener);
        this.radioTypeAuto.addSelectionListener(listener);
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        GeoLocation location;
        int type = 0;
        if (this.radioTypeManual.getSelection()) {
            type = 1;
        } else if (this.radioTypeAuto.getSelection()) {
            type = 2;
        }
        if (type == 1) {
            try {
                location = GeoLocation.parseGeoLocation((String)this.latitude.getText(), (String)this.longitude.getText());
            }
            catch (GeoLocationFormatException geoLocationFormatException) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)"Geolocation format error");
                return false;
            }
        } else {
            location = new GeoLocation(type == 2);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setGeolocation(location);
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Update comments for object " + this.object.getObjectName(), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                return "Cannot modify object's geolocation";
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Location.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.radioTypeUndefined.setSelection(true);
        this.radioTypeManual.setSelection(false);
        this.radioTypeAuto.setSelection(false);
        this.latitude.setText("");
        this.latitude.setEnabled(false);
        this.longitude.setText("");
        this.longitude.setEnabled(false);
    }
}

