/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.ui.eclipse.eventmanager.dialogs.EventSelectionDialog;
import org.netxms.ui.eclipse.filemanager.widgets.LocalFileSelector;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.serverconfig.dialogs.SelectSnmpTrapDialog;
import org.netxms.ui.eclipse.serverconfig.dialogs.helpers.TrapListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.shared.SharedIcons;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.ObjectLabelComparator;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class ExportFileBuilder
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.ExportFileBuilder";
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();
    private FormToolkit toolkit;
    private ScrolledForm form;
    private LocalFileSelector exportFile;
    private LabeledText description;
    private TableViewer templateViewer;
    private TableViewer eventViewer;
    private TableViewer trapViewer;
    private Action actionSave;
    private Set<EventTemplate> events = new HashSet<EventTemplate>();
    private Set<Template> templates = new HashSet<Template>();
    private Set<SnmpTrap> traps = new HashSet<SnmpTrap>();
    private boolean modified = false;
    private List<SnmpTrap> snmpTrapCache = null;

    public void createPartControl(Composite parent) {
        try {
            Platform.getAdapterManager().loadAdapter((Object)new EventTemplate(0L), "org.eclipse.ui.model.IWorkbenchAdapter");
            Platform.getAdapterManager().loadAdapter((Object)this.session.getTopLevelObjects()[0], "org.eclipse.ui.model.IWorkbenchAdapter");
        }
        catch (Exception exception) {}
        this.toolkit = new FormToolkit(this.getSite().getShell().getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setText("Export Configuration");
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        this.form.getBody().setLayout((Layout)layout);
        this.createFileSection();
        this.createTemplateSection();
        this.createEventSection();
        this.createTrapSection();
        this.form.reflow(true);
        this.createActions();
        this.contributeToActionBars();
    }

    private void createFileSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText("Export File");
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        td.colspan = 2;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.exportFile = new LocalFileSelector(clientArea, 0, true);
        this.toolkit.adapt((Composite)this.exportFile);
        this.exportFile.setLabel("File name");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.exportFile.setLayoutData((Object)gd);
        this.description = new LabeledText(clientArea, 0);
        this.toolkit.adapt((Composite)this.description);
        this.description.setLabel("Description");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.description.setLayoutData((Object)gd);
    }

    private void createTemplateSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText("Templates");
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.templateViewer = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.templateViewer.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        gd.verticalSpan = 2;
        this.templateViewer.getTable().setLayoutData((Object)gd);
        this.templateViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.templateViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.templateViewer.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.templateViewer.getLabelProvider()));
        this.templateViewer.getTable().setSortDirection(128);
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        linkAdd.setText("Add...");
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.addTemplates();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        linkRemove.setText("Remove");
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.removeTemplates();
            }
        });
    }

    private void createEventSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText("Events");
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.eventViewer = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.eventViewer.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        gd.verticalSpan = 2;
        this.eventViewer.getTable().setLayoutData((Object)gd);
        this.eventViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.eventViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.eventViewer.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.eventViewer.getLabelProvider()));
        this.eventViewer.getTable().setSortDirection(128);
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        linkAdd.setText("Add...");
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.addEvents();
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        linkRemove.setText("Remove");
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.removeEvents();
            }
        });
    }

    private void createTrapSection() {
        Section section = this.toolkit.createSection(this.form.getBody(), 256);
        section.setText("SNMP Traps");
        TableWrapData td = new TableWrapData();
        td.align = 128;
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite clientArea = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        section.setClient((Control)clientArea);
        this.trapViewer = new TableViewer(clientArea, 67586);
        this.toolkit.adapt((Composite)this.trapViewer.getTable());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        gd.verticalSpan = 2;
        this.trapViewer.getTable().setLayoutData((Object)gd);
        this.trapViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.trapViewer.setLabelProvider((IBaseLabelProvider)new TrapListLabelProvider());
        this.trapViewer.setComparator((ViewerComparator)new ObjectLabelComparator((ILabelProvider)this.eventViewer.getLabelProvider()));
        this.trapViewer.getTable().setSortDirection(128);
        ImageHyperlink linkAdd = this.toolkit.createImageHyperlink(clientArea, 0);
        linkAdd.setText("Add...");
        linkAdd.setImage(SharedIcons.IMG_ADD_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkAdd.setLayoutData((Object)gd);
        linkAdd.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (ExportFileBuilder.this.snmpTrapCache == null) {
                    new ConsoleJob("Loading SNMP trap configuration", (IWorkbenchPart)ExportFileBuilder.this, "org.netxms.ui.eclipse.serverconfig", null){

                        protected void runInternal(IProgressMonitor monitor) throws Exception {
                            ExportFileBuilder.this.snmpTrapCache = ExportFileBuilder.this.session.getSnmpTrapsConfigurationSummary();
                            this.runInUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    ExportFileBuilder.this.addTraps();
                                }
                            });
                        }

                        protected String getErrorMessage() {
                            return "Cannot load SNMP trap configuration";
                        }
                    }.start();
                } else {
                    ExportFileBuilder.this.addTraps();
                }
            }
        });
        ImageHyperlink linkRemove = this.toolkit.createImageHyperlink(clientArea, 0);
        linkRemove.setText("Remove");
        linkRemove.setImage(SharedIcons.IMG_DELETE_OBJECT);
        gd = new GridData();
        gd.verticalAlignment = 128;
        linkRemove.setLayoutData((Object)gd);
        linkRemove.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ExportFileBuilder.this.removeTraps();
            }
        });
    }

    private void createActions() {
        this.actionSave = new Action("&Save"){

            public void run() {
                ExportFileBuilder.this.save();
            }
        };
        this.actionSave.setImageDescriptor(SharedIcons.SAVE);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSave);
    }

    public void setFocus() {
        this.form.setFocus();
    }

    private void setModified() {
        if (!this.modified) {
            this.modified = true;
            this.firePropertyChange(257);
        }
    }

    private void save() {
        if (this.exportFile.getFile() == null) {
            MessageDialogHelper.openWarning((Shell)this.getSite().getShell(), (String)"Warning", (String)"Please enter valid file name to write exported configuration to!");
            return;
        }
        final long[] eventList = new long[this.events.size()];
        int i = 0;
        for (EventTemplate t : this.events) {
            eventList[i++] = t.getCode();
        }
        final long[] templateList = new long[this.templates.size()];
        i = 0;
        for (Template t : this.templates) {
            templateList[i++] = t.getObjectId();
        }
        final long[] trapList = new long[this.traps.size()];
        i = 0;
        for (SnmpTrap t : this.traps) {
            trapList[i++] = t.getId();
        }
        final String descriptionText = this.description.getText();
        new ConsoleJob("Exporting and saving configuration", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                String xml = ExportFileBuilder.this.session.exportConfiguration(descriptionText, eventList, trapList, templateList);
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(ExportFileBuilder.this.exportFile.getFile()), "UTF-8");
                try {
                    out.write(xml);
                }
                finally {
                    out.close();
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ExportFileBuilder.this.modified = false;
                        ExportFileBuilder.this.firePropertyChange(257);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot export configuration";
            }
        }.start();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    private void addEvents() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getSite().getShell());
        dlg.enableMultiSelection(true);
        if (dlg.open() == 0) {
            EventTemplate[] eventTemplateArray = dlg.getSelectedEvents();
            int n = eventTemplateArray.length;
            int n2 = 0;
            while (n2 < n) {
                EventTemplate t = eventTemplateArray[n2];
                this.events.add(t);
                ++n2;
            }
            this.eventViewer.setInput((Object)this.events.toArray());
            this.setModified();
        }
    }

    private void removeEvents() {
        IStructuredSelection selection = (IStructuredSelection)this.eventViewer.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                this.events.remove(o);
            }
            this.eventViewer.setInput((Object)this.events.toArray());
            this.setModified();
        }
    }

    private void addTemplates() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, ObjectSelectionDialog.createTemplateSelectionFilter());
        dlg.enableMultiSelection(true);
        if (dlg.open() == 0) {
            final HashSet<Long> idList = new HashSet<Long>();
            AbstractObject[] abstractObjectArray = dlg.getSelectedObjects(Template.class);
            int n = abstractObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractObject o = abstractObjectArray[n2];
                this.templates.add((Template)o);
                idList.add(o.getObjectId());
                ++n2;
            }
            this.templateViewer.setInput((Object)this.templates.toArray());
            this.setModified();
            new ConsoleJob("Resolving event dependencies", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    final HashSet<Long> eventCodes = new HashSet<Long>();
                    for (Long id : idList) {
                        long[] e;
                        long[] lArray = e = ExportFileBuilder.this.session.getDataCollectionEvents(id.longValue());
                        int n = e.length;
                        int n2 = 0;
                        while (n2 < n) {
                            long c = lArray[n2];
                            if (c >= 100000L) {
                                eventCodes.add(c);
                            }
                            ++n2;
                        }
                    }
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ExportFileBuilder.this.events.addAll(ExportFileBuilder.this.session.findMultipleEventTemplates(eventCodes.toArray(new Long[eventCodes.size()])));
                            ExportFileBuilder.this.eventViewer.setInput((Object)ExportFileBuilder.this.events.toArray());
                        }
                    });
                }

                protected String getErrorMessage() {
                    return null;
                }
            }.start();
        }
    }

    private void removeTemplates() {
        IStructuredSelection selection = (IStructuredSelection)this.templateViewer.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                this.templates.remove(o);
            }
            this.templateViewer.setInput((Object)this.templates.toArray());
            this.setModified();
        }
    }

    private void addTraps() {
        SelectSnmpTrapDialog dlg = new SelectSnmpTrapDialog(this.getSite().getShell(), this.snmpTrapCache);
        if (dlg.open() == 0) {
            HashSet<Long> eventCodes = new HashSet<Long>();
            for (SnmpTrap t : dlg.getSelection()) {
                this.traps.add(t);
                if (t.getEventCode() < 100000) continue;
                eventCodes.add(Long.valueOf(t.getEventCode()));
            }
            this.trapViewer.setInput((Object)this.traps.toArray());
            this.setModified();
            if (eventCodes.size() > 0) {
                this.events.addAll(this.session.findMultipleEventTemplates(eventCodes.toArray(new Long[eventCodes.size()])));
                this.eventViewer.setInput((Object)this.events.toArray());
            }
        }
    }

    private void removeTraps() {
        IStructuredSelection selection = (IStructuredSelection)this.trapViewer.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                this.traps.remove(o);
            }
            this.trapViewer.setInput((Object)this.traps.toArray());
            this.setModified();
        }
    }
}

