/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.tools;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ExtendedPropertyDialog
extends PropertyDialog {
    public ExtendedPropertyDialog(Shell parentShell, PreferenceManager mng, ISelection selection) {
        super(parentShell, mng, selection);
    }

    public void createAllPages() {
        List nodes = this.getPreferenceManager().getElements(1);
        for (IPreferenceNode node : nodes) {
            if (node.getPage() == null) {
                this.createPage(node);
            }
            IPreferencePage page = this.getPage(node);
            page.setContainer((IPreferencePageContainer)this);
            if (page.getControl() != null) continue;
            page.createControl(this.getPageContainer());
        }
    }

    public static ExtendedPropertyDialog createDialogOn(Shell shell, String propertyPageId, Object element, String name) {
        if (element == null) {
            return null;
        }
        PropertyPageManager pageManager = new PropertyPageManager();
        String title = "";
        PropertyPageContributorManager.getManager().contribute(pageManager, element);
        Iterator pages = pageManager.getElements(0).iterator();
        if (!pages.hasNext()) {
            MessageDialogHelper.openInformation(shell, WorkbenchMessages.PropertyDialog_messageTitle, NLS.bind((String)WorkbenchMessages.PropertyDialog_noPropertyMessage, (Object)name));
            return null;
        }
        title = NLS.bind((String)WorkbenchMessages.PropertyDialog_propertyMessage, (Object)name);
        ExtendedPropertyDialog propertyDialog = new ExtendedPropertyDialog(shell, (PreferenceManager)pageManager, (ISelection)new StructuredSelection(element));
        if (propertyPageId != null) {
            propertyDialog.setSelectedNode(propertyPageId);
        }
        propertyDialog.create();
        propertyDialog.getShell().setText(title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)propertyDialog.getShell(), "org.eclipse.ui.property_dialog_context");
        return propertyDialog;
    }
}

