/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServiceRoot;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.Subnet;
import org.netxms.client.objects.Template;
import org.netxms.client.objects.TemplateGroup;
import org.netxms.client.objects.TemplateRoot;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.tools.CommandBridge;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectActionValidator;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectOpenHandler;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectOpenListener;
import org.netxms.ui.eclipse.objectbrowser.api.SubtreeType;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectTree;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectBrowser
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.view.navigation.objectbrowser";
    private ObjectTree objectTree;
    private Action actionShowFilter;
    private Action actionShowStatusIndicator;
    private Action actionHideUnmanaged;
    private Action actionHideTemplateChecks;
    private Action actionMoveObject;
    private Action actionMoveTemplate;
    private Action actionMoveBusinessService;
    private Action actionRefresh;
    private Action actionProperties;
    private boolean initHideUnmanaged = false;
    private boolean initHideTemplateChecks = false;
    private boolean initShowFilter = true;
    private boolean initShowStatus = false;
    private String initialObjectSelection = null;
    private List<OpenHandlerData> openHandlers = new ArrayList<OpenHandlerData>(0);
    private ObjectActionValidator[] actionValidators;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.initHideUnmanaged = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.hideUnmanaged"), false);
            this.initHideTemplateChecks = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.hideTemplateChecks"), false);
            this.initShowFilter = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.showFilter"), true);
            this.initShowStatus = ObjectBrowser.safeCast(memento.getBoolean("ObjectBrowser.showStatusIndicator"), false);
            this.initialObjectSelection = memento.getString("ObjectBrowser.selectedObject");
        }
        this.registerOpenHandlers();
        this.registerActionValidators();
    }

    private static boolean safeCast(Boolean b, boolean defval) {
        return b != null ? b : defval;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putBoolean("ObjectBrowser.hideUnmanaged", this.objectTree.isHideUnmanaged());
        memento.putBoolean("ObjectBrowser.hideTemplateChecks", this.objectTree.isHideTemplateChecks());
        memento.putBoolean("ObjectBrowser.showFilter", this.objectTree.isFilterEnabled());
        memento.putBoolean("ObjectBrowser.showStatusIndicator", this.objectTree.isStatusIndicatorEnabled());
        this.saveSelection(memento);
    }

    public void createPartControl(Composite parent) {
        FormLayout formLayout = new FormLayout();
        parent.setLayout((Layout)formLayout);
        long[] rootObjects = null;
        Object value = ConsoleSharedData.getProperty((String)"ObjectBrowser.rootObjects");
        if (value != null && value instanceof long[]) {
            rootObjects = (long[])value;
        }
        this.objectTree = new ObjectTree(parent, 0, 2, rootObjects, null);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.objectTree.setLayoutData(fd);
        this.objectTree.setHideTemplateChecks(this.initHideTemplateChecks);
        this.objectTree.setHideUnmanaged(this.initHideUnmanaged);
        this.objectTree.enableFilter(this.initShowFilter);
        this.objectTree.enableStatusIndicator(this.initShowStatus);
        this.objectTree.addOpenListener(new ObjectOpenListener(){

            @Override
            public boolean openObject(AbstractObject object) {
                return ObjectBrowser.this.callOpenObjectHandler(object);
            }
        });
        this.createActions();
        this.createMenu();
        this.createToolBar();
        this.createPopupMenu();
        this.objectTree.enableDragSupport();
        this.getSite().setSelectionProvider((ISelectionProvider)this.objectTree.getTreeViewer());
        this.objectTree.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)ObjectBrowser.this.objectTree.getTreeViewer().getSelection()).size();
                ObjectBrowser.this.actionMoveObject.setEnabled(size == 1);
                ObjectBrowser.this.actionProperties.setEnabled(size == 1);
            }
        });
        this.objectTree.setFilterCloseAction(this.actionShowFilter);
        this.activateContext();
        this.restoreSelection();
    }

    private void saveSelection(IMemento memento) {
        ITreeSelection selection = (ITreeSelection)this.objectTree.getTreeViewer().getSelection();
        if (selection.size() == 1) {
            TreePath path = selection.getPaths()[0];
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < path.getSegmentCount()) {
                sb.append('/');
                sb.append(((AbstractObject)path.getSegment(i)).getObjectId());
                ++i;
            }
            memento.putString("ObjectBrowser.selectedObject", sb.toString());
        } else {
            memento.putString("ObjectBrowser.selectedObject", "");
        }
    }

    private void restoreSelection() {
        if (this.initialObjectSelection == null || this.initialObjectSelection.isEmpty() || !this.initialObjectSelection.startsWith("/")) {
            return;
        }
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        String[] parts = this.initialObjectSelection.split("/");
        Object[] elements = new Object[parts.length - 1];
        int i = 1;
        while (i < parts.length) {
            long id;
            try {
                id = Long.parseLong(parts[i]);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            elements[i - 1] = session.findObjectById(id);
            if (elements[i - 1] == null) {
                return;
            }
            ++i;
        }
        this.objectTree.getTreeViewer().setSelection((ISelection)new TreeSelection(new TreePath(elements)), true);
    }

    public void setSelection(long objectId, String tabId) {
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        AbstractObject object = session.findObjectById(objectId);
        if (object != null) {
            this.objectTree.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)object), true);
            if (tabId != null) {
                CommandBridge.getInstance().execute("TabbedObjectView/selectTab", (Object)tabId);
            }
        }
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.objectbrowser.context.ObjectBrowser");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ObjectBrowser.this.objectTree.refresh();
            }
        };
        this.actionMoveObject = new Action(Messages.ObjectBrowser_MoveObject){

            public void run() {
                ObjectBrowser.this.moveObject(SubtreeType.INFRASTRUCTURE);
            }
        };
        this.actionMoveTemplate = new Action(Messages.ObjectBrowser_MoveTemplate){

            public void run() {
                ObjectBrowser.this.moveObject(SubtreeType.TEMPLATES);
            }
        };
        this.actionMoveBusinessService = new Action(Messages.ObjectBrowser_MoveService){

            public void run() {
                ObjectBrowser.this.moveObject(SubtreeType.BUSINESS_SERVICES);
            }
        };
        this.actionHideUnmanaged = new Action(Messages.ObjectBrowser_HideUnmanaged, 2){

            public void run() {
                ObjectBrowser.this.objectTree.setHideUnmanaged(!ObjectBrowser.this.objectTree.isHideUnmanaged());
                ObjectBrowser.this.actionHideUnmanaged.setChecked(ObjectBrowser.this.objectTree.isHideUnmanaged());
            }
        };
        this.actionHideUnmanaged.setChecked(this.objectTree.isHideUnmanaged());
        this.actionHideTemplateChecks = new Action(Messages.ObjectBrowser_HideCheckTemplates, 2){

            public void run() {
                ObjectBrowser.this.objectTree.setHideTemplateChecks(!ObjectBrowser.this.objectTree.isHideTemplateChecks());
                ObjectBrowser.this.actionHideTemplateChecks.setChecked(ObjectBrowser.this.objectTree.isHideTemplateChecks());
            }
        };
        this.actionHideTemplateChecks.setChecked(this.objectTree.isHideTemplateChecks());
        this.actionShowFilter = new Action(Messages.ObjectBrowser_ShowFilter, 2){

            public void run() {
                ObjectBrowser.this.objectTree.enableFilter(!ObjectBrowser.this.objectTree.isFilterEnabled());
                ObjectBrowser.this.actionShowFilter.setChecked(ObjectBrowser.this.objectTree.isFilterEnabled());
            }
        };
        this.actionShowFilter.setChecked(this.objectTree.isFilterEnabled());
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.objectbrowser.commands.show_object_filter");
        ActionHandler showFilterHandler = new ActionHandler((IAction)this.actionShowFilter);
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)showFilterHandler);
        this.actionShowStatusIndicator = new Action(Messages.ObjectBrowser_ShowStatusIndicator, 2){

            public void run() {
                ObjectBrowser.this.objectTree.enableStatusIndicator(ObjectBrowser.this.actionShowStatusIndicator.isChecked());
            }
        };
        this.actionShowStatusIndicator.setChecked(this.objectTree.isStatusIndicatorEnabled());
        this.actionShowStatusIndicator.setActionDefinitionId("org.netxms.ui.eclipse.objectbrowser.commands.show_status_indicator");
        ActionHandler showStatusIndicatorHandler = new ActionHandler((IAction)this.actionShowStatusIndicator);
        handlerService.activateHandler(this.actionShowStatusIndicator.getActionDefinitionId(), (IHandler)showStatusIndicatorHandler);
        this.actionProperties = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.objectTree.getTreeViewer());
    }

    private void createMenu() {
        IMenuManager manager = this.getViewSite().getActionBars().getMenuManager();
        manager.add((IAction)this.actionShowFilter);
        manager.add((IAction)this.actionShowStatusIndicator);
        manager.add((IAction)this.actionHideUnmanaged);
        manager.add((IAction)this.actionHideTemplateChecks);
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createToolBar() {
        IToolBarManager manager = this.getViewSite().getActionBars().getToolBarManager();
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ObjectBrowser.this.fillContextMenu(mgr);
            }
        });
        Menu menu = manager.createContextMenu((Control)this.objectTree.getTreeControl());
        this.objectTree.getTreeControl().setMenu(menu);
        this.getSite().registerContextMenu(manager, (ISelectionProvider)this.objectTree.getTreeViewer());
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("objectcreation"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("nxvs"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectmgmt"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectbinding"));
        if (this.isValidSelectionForMove(SubtreeType.INFRASTRUCTURE)) {
            manager.add((IAction)this.actionMoveObject);
        }
        if (this.isValidSelectionForMove(SubtreeType.TEMPLATES)) {
            manager.add((IAction)this.actionMoveTemplate);
        }
        if (this.isValidSelectionForMove(SubtreeType.BUSINESS_SERVICES)) {
            manager.add((IAction)this.actionMoveBusinessService);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("topology"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("datacollection"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("properties"));
        manager.add((IAction)this.actionProperties);
    }

    public void setFocus() {
        this.objectTree.setFocus();
    }

    public void dispose() {
        super.dispose();
    }

    private boolean isValidSelectionForMove(SubtreeType subtree) {
        TreeItem[] selection = this.objectTree.getTreeControl().getSelection();
        if (selection.length != 1) {
            return false;
        }
        if (selection[0].getParentItem() == null) {
            return false;
        }
        AbstractObject currentObject = (AbstractObject)selection[0].getData();
        AbstractObject parentObject = (AbstractObject)selection[0].getParentItem().getData();
        ObjectActionValidator[] objectActionValidatorArray = this.actionValidators;
        int n = this.actionValidators.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectActionValidator v = objectActionValidatorArray[n2];
            int result = v.isValidSelectionForMove(subtree, currentObject, parentObject);
            if (result == 0) {
                return true;
            }
            if (result == 1) {
                return false;
            }
            ++n2;
        }
        return false;
    }

    private void moveObject(SubtreeType subtree) {
        AbstractObject target;
        Set<Integer> filter;
        if (!this.isValidSelectionForMove(subtree)) {
            return;
        }
        TreeItem[] selection = this.objectTree.getTreeControl().getSelection();
        final Object currentObject = selection[0].getData();
        final Object parentObject = selection[0].getParentItem().getData();
        switch (subtree) {
            case INFRASTRUCTURE: {
                filter = ObjectSelectionDialog.createContainerSelectionFilter();
                break;
            }
            case TEMPLATES: {
                filter = ObjectSelectionDialog.createTemplateSelectionFilter();
                break;
            }
            case BUSINESS_SERVICES: {
                filter = ObjectSelectionDialog.createBusinessServiceSelectionFilter();
                break;
            }
            default: {
                filter = null;
            }
        }
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getSite().getShell(), null, filter);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0 && (target = dlg.getSelectedObjects().get(0)).getObjectId() != ((AbstractObject)parentObject).getObjectId()) {
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            new ConsoleJob(String.valueOf(Messages.ObjectBrowser_MoveJob_Title) + ((AbstractObject)currentObject).getObjectName(), (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectbrowser", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    long objectId = ((AbstractObject)currentObject).getObjectId();
                    session.bindObject(target.getObjectId(), objectId);
                    session.unbindObject(((AbstractObject)parentObject).getObjectId(), objectId);
                }

                protected String getErrorMessage() {
                    return String.valueOf(Messages.ObjectBrowser_MoveJob_Error) + ((AbstractObject)currentObject).getObjectName();
                }
            }.start();
        }
    }

    private void registerOpenHandlers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objectbrowser.objectOpenHandlers");
        int i = 0;
        while (i < elements.length) {
            try {
                OpenHandlerData h = new OpenHandlerData();
                h.handler = (ObjectOpenHandler)elements[i].createExecutableExtension("class");
                h.priority = ObjectBrowser.safeParseInt(elements[i].getAttribute("priority"));
                String className = elements[i].getAttribute("enabledFor");
                try {
                    h.enabledFor = className != null ? Class.forName(className) : null;
                }
                catch (Exception exception) {
                    h.enabledFor = null;
                }
                this.openHandlers.add(h);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Collections.sort(this.openHandlers, new Comparator<OpenHandlerData>(){

            @Override
            public int compare(OpenHandlerData arg0, OpenHandlerData arg1) {
                return arg0.priority - arg1.priority;
            }
        });
    }

    private void registerActionValidators() {
        ArrayList<ActionValidatorData> list = new ArrayList<ActionValidatorData>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objectbrowser.objectActionValidators");
        int i = 0;
        while (i < elements.length) {
            try {
                ActionValidatorData v = new ActionValidatorData();
                v.validator = (ObjectActionValidator)elements[i].createExecutableExtension("class");
                v.priority = ObjectBrowser.safeParseInt(elements[i].getAttribute("priority"));
                list.add(v);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Collections.sort(list, new Comparator<ActionValidatorData>(){

            @Override
            public int compare(ActionValidatorData arg0, ActionValidatorData arg1) {
                return arg0.priority - arg1.priority;
            }
        });
        this.actionValidators = new ObjectActionValidator[list.size() + 1];
        i = 0;
        for (ActionValidatorData v : list) {
            this.actionValidators[i++] = v.validator;
        }
        this.actionValidators[i] = new ObjectActionValidator(){

            @Override
            public int isValidSelectionForMove(SubtreeType subtree, AbstractObject currentObject, AbstractObject parentObject) {
                switch (subtree) {
                    case INFRASTRUCTURE: {
                        return !(!(currentObject instanceof Node) && !(currentObject instanceof Cluster) && !(currentObject instanceof Subnet) && !(currentObject instanceof Condition) && !(currentObject instanceof Rack) && !(currentObject instanceof Container) || !(parentObject instanceof Container) && !(parentObject instanceof ServiceRoot)) ? 0 : 1;
                    }
                    case TEMPLATES: {
                        return !(!(currentObject instanceof Template) && !(currentObject instanceof TemplateGroup) || !(parentObject instanceof TemplateGroup) && !(parentObject instanceof TemplateRoot)) ? 0 : 1;
                    }
                    case BUSINESS_SERVICES: {
                        return currentObject instanceof BusinessService && (parentObject instanceof BusinessService || parentObject instanceof BusinessServiceRoot) ? 0 : 1;
                    }
                }
                return 1;
            }
        };
    }

    private static int safeParseInt(String s) {
        if (s == null) {
            return 65535;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 65535;
        }
    }

    private boolean callOpenObjectHandler(AbstractObject object) {
        for (OpenHandlerData h : this.openHandlers) {
            if (h.enabledFor != null && !h.enabledFor.isInstance(object) || !h.handler.openObject(object)) continue;
            return true;
        }
        return false;
    }

    private class ActionValidatorData {
        ObjectActionValidator validator;
        int priority;

        private ActionValidatorData() {
        }
    }

    private class OpenHandlerData {
        ObjectOpenHandler handler;
        int priority;
        Class<?> enabledFor;

        private OpenHandlerData() {
        }
    }
}

