/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers.internal;

import java.util.List;
import org.eclipse.zest.core.viewers.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.IFigureProvider;
import org.eclipse.zest.core.viewers.IGraphContentProvider;
import org.eclipse.zest.core.viewers.internal.AbstractStylingModelFactory;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;

public class GraphModelFactory
extends AbstractStylingModelFactory {
    AbstractStructuredGraphViewer viewer = null;

    public GraphModelFactory(AbstractStructuredGraphViewer viewer) {
        super(viewer);
        this.viewer = viewer;
    }

    @Override
    public Graph createGraphModel(Graph model) {
        this.doBuildGraph(model);
        return model;
    }

    @Override
    protected void doBuildGraph(Graph model) {
        super.doBuildGraph(model);
        Object[] rels = this.getContentProvider().getElements(this.getViewer().getInput());
        if (rels != null) {
            IFigureProvider figureProvider = null;
            if (this.getLabelProvider() instanceof IFigureProvider) {
                figureProvider = (IFigureProvider)this.getLabelProvider();
            }
            int i = 0;
            while (i < rels.length) {
                Object source = this.getCastedContent().getSource(rels[i]);
                source = this.filterElement(this.getViewer().getInput(), source) ? null : source;
                Object dest = this.getCastedContent().getDestination(rels[i]);
                Object object = dest = this.filterElement(this.getViewer().getInput(), dest) ? null : dest;
                if (source == null) {
                    if (dest != null) {
                        if (figureProvider != null) {
                            this.createNode(model, dest, figureProvider.getFigure(dest));
                        } else {
                            this.createNode(model, dest);
                        }
                    }
                } else if (dest == null) {
                    if (source != null) {
                        if (figureProvider != null) {
                            this.createNode(model, source, figureProvider.getFigure(source));
                        } else {
                            this.createNode(model, source);
                        }
                    }
                } else if (source != null && dest != null && !this.filterElement(this.getViewer().getInput(), rels[i])) {
                    this.createConnection(model, rels[i], this.getCastedContent().getSource(rels[i]), this.getCastedContent().getDestination(rels[i]));
                }
                ++i;
            }
        }
    }

    private IGraphContentProvider getCastedContent() {
        return (IGraphContentProvider)this.getContentProvider();
    }

    @Override
    public void refresh(Graph graph, Object element) {
        this.refresh(graph, element, false);
    }

    @Override
    public void refresh(Graph graph, Object element, boolean updateLabels) {
        GraphConnection conn = this.viewer.getGraphModelConnection(element);
        if (conn == null) {
            GraphNode node = this.viewer.getGraphModelNode(element);
            if (node != null) {
                List connections = node.getSourceConnections();
                for (GraphConnection c : connections) {
                    this.refresh(graph, c.getExternalConnection(), updateLabels);
                }
                connections = node.getTargetConnections();
                for (GraphConnection c : connections) {
                    this.refresh(graph, c.getExternalConnection(), updateLabels);
                }
            }
            return;
        }
        Object oldSource = conn.getSource().getData();
        Object oldDest = conn.getDestination().getData();
        Object newSource = this.getCastedContent().getSource(element);
        Object newDest = this.getCastedContent().getDestination(element);
        if (!oldSource.equals(newSource) || !oldDest.equals(newDest)) {
            GraphNode internalSource = this.viewer.getGraphModelNode(newSource);
            GraphNode internalDest = this.viewer.getGraphModelNode(newDest);
            if (internalSource == null) {
                internalSource = this.createNode(graph, newSource);
            } else if (updateLabels) {
                this.styleItem((GraphItem)internalSource);
            }
            if (internalDest == null) {
                internalDest = this.createNode(graph, newDest);
            } else if (updateLabels) {
                this.styleItem((GraphItem)internalDest);
            }
            if (updateLabels) {
                this.styleItem((GraphItem)conn);
            }
        }
    }
}

