/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.datacollection.Threshold;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.eventmanager.widgets.EventSelector;
import org.netxms.ui.eclipse.tools.NumericTextFieldValidator;
import org.netxms.ui.eclipse.tools.TextFieldValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class EditThresholdDialog
extends Dialog {
    private Threshold threshold;
    private Combo function;
    private Combo operation;
    private Text samples;
    private Text value;
    private EventSelector activationEvent;
    private EventSelector deactivationEvent;
    private Text repeatInterval;
    private Button repeatDefault;
    private Button repeatNever;
    private Button repeatCustom;

    public EditThresholdDialog(Shell parentShell, Threshold threshold) {
        super(parentShell);
        this.threshold = threshold;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        RowLayout dialogLayout = new RowLayout();
        dialogLayout.type = 512;
        dialogLayout.fill = true;
        dialogArea.setLayout((Layout)dialogLayout);
        Group condGroup = new Group(dialogArea, 0);
        condGroup.setText(Messages.EditThresholdDialog_Condition);
        GridLayout condLayout = new GridLayout();
        condLayout.numColumns = 2;
        condGroup.setLayout((Layout)condLayout);
        this.function = WidgetHelper.createLabeledCombo((Composite)condGroup, (int)2060, (String)Messages.EditThresholdDialog_Function, (Object)"WidgetHelper::default_layout_data");
        this.function.add(Messages.EditThresholdDialog_LastValue);
        this.function.add(Messages.EditThresholdDialog_AvgValue);
        this.function.add(Messages.EditThresholdDialog_MeanDeviation);
        this.function.add(Messages.EditThresholdDialog_Diff);
        this.function.add(Messages.EditThresholdDialog_DCError);
        this.function.add(Messages.EditThresholdDialog_Sum);
        this.function.select(this.threshold.getFunction());
        this.samples = WidgetHelper.createLabeledText((Composite)condGroup, (int)2048, (int)60, (String)Messages.EditThresholdDialog_Samples, (String)Integer.toString(this.threshold.getArg1()), (Object)"WidgetHelper::default_layout_data");
        this.samples.setTextLimit(5);
        this.operation = WidgetHelper.createLabeledCombo((Composite)condGroup, (int)2060, (String)Messages.EditThresholdDialog_Function, (Object)"WidgetHelper::default_layout_data");
        this.operation.add(Messages.EditThresholdDialog_LT);
        this.operation.add(Messages.EditThresholdDialog_LE);
        this.operation.add(Messages.EditThresholdDialog_EQ);
        this.operation.add(Messages.EditThresholdDialog_GE);
        this.operation.add(Messages.EditThresholdDialog_GT);
        this.operation.add(Messages.EditThresholdDialog_NE);
        this.operation.add(Messages.EditThresholdDialog_LIKE);
        this.operation.add(Messages.EditThresholdDialog_NOTLIKE);
        this.operation.select(this.threshold.getOperation());
        this.value = WidgetHelper.createLabeledText((Composite)condGroup, (int)2048, (int)120, (String)Messages.EditThresholdDialog_Value, (String)this.threshold.getValue(), (Object)"WidgetHelper::default_layout_data");
        Group eventGroup = new Group(dialogArea, 0);
        eventGroup.setText(Messages.EditThresholdDialog_Event);
        GridLayout eventLayout = new GridLayout();
        eventGroup.setLayout((Layout)eventLayout);
        this.activationEvent = new EventSelector((Composite)eventGroup, 0);
        this.activationEvent.setLabel(Messages.EditThresholdDialog_ActEvent);
        this.activationEvent.setEventCode((long)this.threshold.getFireEvent());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.activationEvent.setLayoutData((Object)gd);
        this.deactivationEvent = new EventSelector((Composite)eventGroup, 0);
        this.deactivationEvent.setLabel(Messages.EditThresholdDialog_DeactEvent);
        this.deactivationEvent.setEventCode((long)this.threshold.getRearmEvent());
        this.deactivationEvent.setLayoutData((Object)gd);
        Group repeatGroup = new Group(dialogArea, 0);
        repeatGroup.setText(Messages.EditThresholdDialog_RepeatEvent);
        GridLayout repeatLayout = new GridLayout();
        repeatLayout.numColumns = 3;
        repeatGroup.setLayout((Layout)repeatLayout);
        this.repeatDefault = new Button((Composite)repeatGroup, 16);
        this.repeatDefault.setText(Messages.EditThresholdDialog_UseDefault);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 3;
        this.repeatDefault.setLayoutData((Object)gd);
        this.repeatDefault.setSelection(this.threshold.getRepeatInterval() == -1);
        this.repeatNever = new Button((Composite)repeatGroup, 16);
        this.repeatNever.setText(Messages.EditThresholdDialog_Never);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 3;
        this.repeatNever.setLayoutData((Object)gd);
        this.repeatNever.setSelection(this.threshold.getRepeatInterval() == 0);
        this.repeatCustom = new Button((Composite)repeatGroup, 16);
        this.repeatCustom.setText(Messages.EditThresholdDialog_Every);
        this.repeatCustom.setSelection(this.threshold.getRepeatInterval() > 0);
        this.repeatCustom.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                EditThresholdDialog.this.repeatInterval.setEnabled(EditThresholdDialog.this.repeatCustom.getSelection());
            }
        });
        this.repeatInterval = new Text((Composite)repeatGroup, 2048);
        this.repeatInterval.setTextLimit(5);
        this.repeatInterval.setText(this.threshold.getRepeatInterval() > 0 ? Integer.toString(this.threshold.getRepeatInterval()) : "3600");
        this.repeatInterval.setEnabled(this.threshold.getRepeatInterval() > 0);
        new Label((Composite)repeatGroup, 0).setText(Messages.EditThresholdDialog_Seconds);
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.EditThresholdDialog_Title);
    }

    protected void okPressed() {
        int rpt;
        if (!WidgetHelper.validateTextInput((Text)this.samples, (String)Messages.EditThresholdDialog_Samples, (TextFieldValidator)new NumericTextFieldValidator(1L, 1000L), null)) {
            return;
        }
        if (this.repeatDefault.getSelection()) {
            rpt = -1;
        } else if (this.repeatNever.getSelection()) {
            rpt = 0;
        } else {
            if (!WidgetHelper.validateTextInput((Text)this.repeatInterval, (String)Messages.EditThresholdDialog_RepeatInterval, (TextFieldValidator)new NumericTextFieldValidator(1L, 1000000L), null)) {
                return;
            }
            rpt = Integer.parseInt(this.repeatInterval.getText());
        }
        this.threshold.setFunction(this.function.getSelectionIndex());
        this.threshold.setOperation(this.operation.getSelectionIndex());
        this.threshold.setValue(this.value.getText());
        this.threshold.setArg1(Integer.parseInt(this.samples.getText()));
        this.threshold.setRepeatInterval(rpt);
        this.threshold.setFireEvent((int)this.activationEvent.getEventCode());
        this.threshold.setRearmEvent((int)this.deactivationEvent.getEventCode());
        super.okPressed();
    }
}

