/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.api.client.mt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netxms.api.client.mt.MappingTableEntry;
import org.netxms.base.NXCPMessage;

public class MappingTable {
    public static final int NUMERIC_KEYS = 1;
    private int id;
    private String name;
    private String description;
    private int flags;
    private List<MappingTableEntry> data;
    private Map<String, String> hashMap = null;

    public MappingTable(String name, String description) {
        this.id = 0;
        this.name = name;
        this.description = description;
        this.flags = 0;
        this.data = new ArrayList<MappingTableEntry>(0);
    }

    public MappingTable(NXCPMessage msg) {
        this.id = msg.getVariableAsInteger(434L);
        this.name = msg.getVariableAsString(20L);
        this.description = msg.getVariableAsString(27L);
        this.flags = msg.getVariableAsInteger(13L);
        int count2 = msg.getVariableAsInteger(361L);
        this.data = new ArrayList<MappingTableEntry>(count2);
        long varId = 0x10000000L;
        for (int i = 0; i < count2; ++i) {
            this.data.add(new MappingTableEntry(msg, varId));
            varId += 10L;
        }
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setVariableInt32(434L, this.id);
        msg.setVariable(20L, this.name);
        msg.setVariable(27L, this.description);
        msg.setVariableInt32(13L, this.flags);
        msg.setVariableInt32(361L, this.data.size());
        long varId = 0x10000000L;
        for (MappingTableEntry e : this.data) {
            msg.setVariable(varId++, e.getKey());
            msg.setVariable(varId++, e.getValue());
            msg.setVariable(varId++, e.getDescription());
            varId += 7L;
        }
    }

    public String lookup(String key) {
        if (this.hashMap == null) {
            this.buildHash();
        }
        return this.hashMap.get(key);
    }

    public void buildHash() {
        this.hashMap = new HashMap<String, String>(this.data.size());
        for (MappingTableEntry e : this.data) {
            this.hashMap.put(e.getKey(), e.getValue());
        }
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final void setFlags(int flags) {
        this.flags = flags;
    }

    public final int getId() {
        return this.id;
    }

    public final List<MappingTableEntry> getData() {
        return this.data;
    }
}

