/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.zip.CRC32;
import org.netxms.base.EncryptionContext;
import org.netxms.base.NXCPDataInputStream;
import org.netxms.base.NXCPException;
import org.netxms.base.NXCPVariable;

public class NXCPMessage {
    public static final int HEADER_SIZE = 16;
    public static final int ENCRYPTION_HEADER_SIZE = 8;
    public static final int MF_BINARY = 1;
    public static final int MF_END_OF_FILE = 2;
    public static final int MF_DONT_ENCRYPT = 4;
    public static final int MF_END_OF_SEQUENCE = 8;
    public static final int MF_REVERSE_ORDER = 16;
    public static final int MF_CONTROL = 32;
    private int messageCode;
    private int messageFlags;
    private long messageId;
    private Map<Long, NXCPVariable> variableMap = new HashMap<Long, NXCPVariable>(0);
    private long timestamp;
    private byte[] binaryData = null;
    private long controlData = 0L;

    public NXCPMessage(int msgCode) {
        this.messageCode = msgCode;
        this.messageId = 0L;
        this.messageFlags = 0;
    }

    public NXCPMessage(int msgCode, long msgId) {
        this.messageCode = msgCode;
        this.messageId = msgId;
        this.messageFlags = 0;
    }

    public NXCPMessage(byte[] nxcpMessage, EncryptionContext ectx) throws IOException, NXCPException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(nxcpMessage);
        NXCPDataInputStream inputStream = new NXCPDataInputStream(byteArrayInputStream);
        this.messageCode = inputStream.readUnsignedShort();
        if (this.messageCode == 131) {
            byte[] payload;
            if (ectx == null) {
                throw new NXCPException(4);
            }
            byte padding = inputStream.readByte();
            inputStream.skipBytes(1);
            int msgLen = inputStream.readInt();
            try {
                payload = ectx.decryptMessage(inputStream, msgLen - padding - 8);
            }
            catch (GeneralSecurityException e) {
                throw new NXCPException(4, (Throwable)e);
            }
            ByteArrayInputStream payloadByteArrayInputStream = new ByteArrayInputStream(payload);
            NXCPDataInputStream payloadInputStream = new NXCPDataInputStream(payloadByteArrayInputStream);
            CRC32 crc32 = new CRC32();
            crc32.update(payload, 8, payload.length - 8);
            if (payloadInputStream.readUnsignedInt() != crc32.getValue()) {
                throw new NXCPException(4);
            }
            payloadInputStream.skip(4L);
            this.messageCode = payloadInputStream.readUnsignedShort();
            this.createFromStream(payloadInputStream, payloadByteArrayInputStream);
        } else {
            this.createFromStream(inputStream, byteArrayInputStream);
        }
    }

    private void createFromStream(NXCPDataInputStream inputStream, ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.messageFlags = inputStream.readUnsignedShort();
        inputStream.skipBytes(4);
        this.messageId = inputStream.readInt();
        if ((this.messageFlags & 1) == 1) {
            int size = inputStream.readInt();
            this.binaryData = new byte[size];
            inputStream.readFully(this.binaryData);
        } else if ((this.messageFlags & 0x20) == 32) {
            this.controlData = inputStream.readUnsignedInt();
        } else {
            int numVars = inputStream.readInt();
            for (int i = 0; i < numVars; ++i) {
                byteArrayInputStream.mark(byteArrayInputStream.available());
                byte[] df = new byte[16];
                inputStream.readFully(df, 0, 8);
                switch (df[4]) {
                    case 3: {
                        break;
                    }
                    case 0: 
                    case 2: 
                    case 5: {
                        inputStream.readFully(df, 8, 8);
                        break;
                    }
                    case 1: 
                    case 4: {
                        int size = inputStream.readInt();
                        byteArrayInputStream.reset();
                        df = new byte[size + 12];
                        inputStream.readFully(df);
                        int rem = (size + 12) % 8;
                        if (rem == 0) break;
                        inputStream.skipBytes(8 - rem);
                    }
                }
                NXCPVariable variable = new NXCPVariable(df);
                this.variableMap.put(variable.getVariableId(), variable);
            }
        }
    }

    public int getMessageCode() {
        return this.messageCode;
    }

    public void setMessageCode(int msgCode) {
        this.messageCode = msgCode;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(long msgId) {
        this.messageId = msgId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public NXCPVariable findVariable(long varId) {
        return this.variableMap.get(varId);
    }

    public void setVariable(NXCPVariable variable) {
        this.variableMap.put(variable.getVariableId(), variable);
    }

    public void setVariable(long varId, byte[] value) {
        this.setVariable(new NXCPVariable(varId, value));
    }

    public void setVariable(long varId, long[] value) {
        this.setVariable(new NXCPVariable(varId, value));
    }

    public void setVariable(long varId, Long[] value) {
        this.setVariable(new NXCPVariable(varId, value));
    }

    public void setVariable(long varId, String value) {
        this.setVariable(new NXCPVariable(varId, value));
    }

    public void setVariable(long varId, Double value) {
        this.setVariable(new NXCPVariable(varId, value));
    }

    public void setVariable(long varId, InetAddress value) {
        this.setVariable(new NXCPVariable(varId, value));
    }

    public void setVariable(long varId, UUID value) {
        this.setVariable(new NXCPVariable(varId, value));
    }

    public void setVariableInt64(long varId, long value) {
        this.setVariable(new NXCPVariable(varId, 2, value));
    }

    public void setVariableInt32(long varId, int value) {
        this.setVariable(new NXCPVariable(varId, 0, Long.valueOf(value)));
    }

    public void setVariableInt16(long varId, int value) {
        this.setVariable(new NXCPVariable(varId, 3, Long.valueOf(value)));
    }

    public byte[] getVariableAsBinary(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsBinary() : null;
    }

    public String getVariableAsString(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsString() : "";
    }

    public Double getVariableAsReal(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsReal() : 0.0;
    }

    public int getVariableAsInteger(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsInteger().intValue() : 0;
    }

    public long getVariableAsInt64(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsInteger() : 0L;
    }

    public InetAddress getVariableAsInetAddress(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsInetAddress() : null;
    }

    public UUID getVariableAsUUID(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsUUID() : null;
    }

    public long[] getVariableAsUInt32Array(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsUInt32Array() : null;
    }

    public Long[] getVariableAsUInt32ArrayEx(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsUInt32ArrayEx() : null;
    }

    public boolean getVariableAsBoolean(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? var.getAsInteger() != 0L : false;
    }

    public Date getVariableAsDate(long varId) {
        NXCPVariable var = this.findVariable(varId);
        return var != null ? new Date(var.getAsInteger() * 1000L) : null;
    }

    public byte[] createNXCPMessage() throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteStream);
        if ((this.messageFlags & 0x20) == 32) {
            outputStream.writeShort(this.messageCode);
            outputStream.writeShort(this.messageFlags);
            outputStream.writeInt(16);
            outputStream.writeInt((int)this.messageId);
            outputStream.writeInt((int)this.controlData);
        } else if ((this.messageFlags & 1) == 1) {
            outputStream.writeShort(this.messageCode);
            outputStream.writeShort(this.messageFlags);
            int length = this.binaryData.length;
            int padding = 8 - (length + 16) % 8 & 7;
            int packetSize = length + 16 + padding;
            outputStream.writeInt(packetSize);
            outputStream.writeInt((int)this.messageId);
            outputStream.writeInt(length);
            outputStream.write(this.binaryData);
            for (int i = 0; i < padding; ++i) {
                outputStream.writeByte(0);
            }
        } else {
            for (NXCPVariable nxcpVariable : this.variableMap.values()) {
                byte[] field = nxcpVariable.createNXCPDataField();
                outputStream.write(field);
            }
            byte[] payload = byteStream.toByteArray();
            byteStream = new ByteArrayOutputStream();
            outputStream = new DataOutputStream(byteStream);
            outputStream.writeShort(this.messageCode);
            outputStream.writeShort(this.messageFlags);
            outputStream.writeInt(payload.length + 16);
            outputStream.writeInt((int)this.messageId);
            outputStream.writeInt(this.variableMap.size());
            outputStream.write(payload);
        }
        return byteStream.toByteArray();
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
    }

    public boolean isBinaryMessage() {
        return (this.messageFlags & 1) == 1;
    }

    public void setBinaryMessage(boolean isRaw) {
        this.messageFlags = isRaw ? (this.messageFlags |= 1) : (this.messageFlags &= 0xFFFFFFFE);
    }

    public boolean isControlMessage() {
        return (this.messageFlags & 0x20) == 32;
    }

    public void setControl(boolean isControl) {
        this.messageFlags = isControl ? (this.messageFlags |= 0x20) : (this.messageFlags &= 0xFFFFFFDF);
    }

    public boolean isEndOfFile() {
        return (this.messageFlags & 2) == 2;
    }

    public void setEndOfFile(boolean isEOF) {
        this.messageFlags = isEOF ? (this.messageFlags |= 2) : (this.messageFlags &= 0xFFFFFFFD);
    }

    public boolean isEndOfSequence() {
        return (this.messageFlags & 8) == 8;
    }

    public void setEndOfSequence(boolean isEOS) {
        this.messageFlags = isEOS ? (this.messageFlags |= 8) : (this.messageFlags &= 0xFFFFFFF7);
    }

    public boolean isEncryptionDisabled() {
        return (this.messageFlags & 4) == 4;
    }

    public void setEncryptionDisabled(boolean disabled) {
        this.messageFlags = disabled ? (this.messageFlags |= 4) : (this.messageFlags &= 0xFFFFFFFB);
    }

    public long getControlData() {
        return this.controlData;
    }

    public void setControlData(long controlData) {
        this.controlData = controlData;
    }

    public String toString() {
        return "NXCPMessage [messageCode=" + this.messageCode + ", messageFlags=" + this.messageFlags + ", messageId=" + this.messageId + ", variableMap=" + this.variableMap + ", timestamp=" + this.timestamp + "]";
    }
}

