/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import org.netxms.base.NXCPMessage;

public class TableColumnDefinition {
    private String name;
    private String displayName;
    private int dataType;
    private boolean instanceColumn;

    public TableColumnDefinition(String name, String displayName, int dataType, boolean instanceColumn) {
        this.name = name;
        this.displayName = displayName != null ? displayName : name;
        this.dataType = dataType;
        this.instanceColumn = instanceColumn;
    }

    protected TableColumnDefinition(NXCPMessage msg, long baseId) {
        this.name = msg.getVariableAsString(baseId);
        this.dataType = msg.getVariableAsInteger(baseId + 1L);
        this.displayName = msg.getVariableAsString(baseId + 2L);
        if (this.displayName == null) {
            this.displayName = this.name;
        }
        this.instanceColumn = msg.getVariableAsBoolean(baseId + 3L);
    }

    protected void fillMessage(NXCPMessage msg, long baseId) {
        msg.setVariable(baseId, this.name);
        msg.setVariableInt32(baseId + 1L, this.dataType);
        msg.setVariable(baseId + 2L, this.displayName);
        msg.setVariableInt16(baseId + 3L, this.instanceColumn ? 1 : 0);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getDataType() {
        return this.dataType;
    }

    public boolean isInstanceColumn() {
        return this.instanceColumn;
    }
}

