/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netxms.base.NXCPMessage;
import org.netxms.client.AccessListElement;
import org.netxms.client.datacollection.GraphSettingsChangeListener;

public class GraphSettings {
    public static final int MAX_GRAPH_ITEM_COUNT = 16;
    public static final int TIME_FRAME_FIXED = 0;
    public static final int TIME_FRAME_BACK_FROM_NOW = 1;
    public static final int TIME_FRAME_CURRENT = 2;
    public static final int TIME_UNIT_MINUTE = 0;
    public static final int TIME_UNIT_HOUR = 1;
    public static final int TIME_UNIT_DAY = 2;
    public static final int GF_AUTO_UPDATE = 1;
    public static final int GF_AUTO_SCALE = 256;
    public static final int GF_SHOW_GRID = 512;
    public static final int GF_SHOW_LEGEND = 1024;
    public static final int GF_SHOW_RULER = 2048;
    public static final int GF_SHOW_HOST_NAMES = 4096;
    public static final int GF_LOG_SCALE = 8192;
    public static final int GF_SHOW_TOOLTIPS = 16384;
    public static final int GF_ENABLE_ZOOM = 32768;
    public static final int POSITION_LEFT = 1;
    public static final int POSITION_RIGHT = 2;
    public static final int POSITION_TOP = 4;
    public static final int POSITION_BOTTOM = 8;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;
    private long id;
    private long ownerId;
    private String name;
    private String shortName;
    private List<AccessListElement> accessList;
    private String config;
    private Set<GraphSettingsChangeListener> changeListeners = new HashSet<GraphSettingsChangeListener>(0);

    public GraphSettings() {
        this.id = 0L;
        this.ownerId = 0L;
        this.name = "noname";
        this.shortName = "noname";
        this.accessList = new ArrayList<AccessListElement>(0);
        this.config = "<chart></chart>";
    }

    public GraphSettings(long id, long ownerId, Collection<AccessListElement> accessList) {
        this.id = id;
        this.ownerId = ownerId;
        this.name = "noname";
        this.shortName = "noname";
        this.accessList = new ArrayList<AccessListElement>(accessList.size());
        this.accessList.addAll(accessList);
        this.config = "<chart></chart>";
    }

    public GraphSettings(NXCPMessage msg, long baseId) {
        this.id = msg.getVariableAsInt64(baseId);
        this.ownerId = msg.getVariableAsInt64(baseId + 1L);
        this.name = msg.getVariableAsString(baseId + 2L);
        String[] parts = this.name.split("->");
        this.shortName = parts.length > 1 ? parts[parts.length - 1] : this.name;
        int count2 = msg.getVariableAsInteger(baseId + 4L);
        long[] users = msg.getVariableAsUInt32Array(baseId + 5L);
        long[] rights = msg.getVariableAsUInt32Array(baseId + 6L);
        this.accessList = new ArrayList<AccessListElement>(count2);
        for (int i = 0; i < count2; ++i) {
            this.accessList.add(new AccessListElement(users[i], (int)rights[i]));
        }
        this.config = msg.getVariableAsString(baseId + 3L);
    }

    public long getId() {
        return this.id;
    }

    public long getOwnerId() {
        return this.ownerId;
    }

    public String getName() {
        return this.name;
    }

    public List<AccessListElement> getAccessList() {
        return this.accessList;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setName(String name) {
        this.name = name;
        String[] parts = name.split("->");
        this.shortName = parts.length > 1 ? parts[parts.length - 1] : name;
    }

    public void addChangeListener(GraphSettingsChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(GraphSettingsChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void fireChangeNotification() {
        for (GraphSettingsChangeListener l : this.changeListeners) {
            l.onGraphSettingsChange(this);
        }
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }
}

