/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.log;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netxms.base.NXCPMessage;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.OrderingColumn;

public class LogFilter {
    private HashMap<String, ColumnFilter> columnFilters = new HashMap();
    private List<OrderingColumn> orderingColumns = new ArrayList<OrderingColumn>();

    public void setColumnFilter(String column, ColumnFilter filter) {
        this.columnFilters.put(column, filter);
    }

    public ColumnFilter getColumnFilter(String column) {
        return this.columnFilters.get(column);
    }

    public void clearColumnFilter(String column) {
        this.columnFilters.remove(column);
    }

    public Set<Map.Entry<String, ColumnFilter>> getColumnFilters() {
        return this.columnFilters.entrySet();
    }

    public List<OrderingColumn> getOrderingColumns() {
        return this.orderingColumns;
    }

    public void setOrderingColumns(List<OrderingColumn> orderingColumns) {
        this.orderingColumns = orderingColumns;
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setVariableInt32(341L, this.columnFilters.size());
        long varId = 0x10000000L;
        for (Map.Entry<String, ColumnFilter> e : this.columnFilters.entrySet()) {
            msg.setVariable(varId++, e.getKey());
            varId += (long)e.getValue().fillMessage(msg, varId);
        }
        if (this.orderingColumns != null) {
            msg.setVariableInt32(345L, this.orderingColumns.size());
            varId = 0x40000000L;
            for (OrderingColumn c : this.orderingColumns) {
                msg.setVariable(varId++, c.getName());
                msg.setVariableInt16(varId++, c.isDescending() ? 1 : 0);
            }
        } else {
            msg.setVariableInt32(345L, 0);
        }
    }
}

