/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.primitives;

import com.google.common.annotations.GwtCompatible;

@GwtCompatible
final class ParseRequest {
    final String rawValue;
    final int radix;

    private ParseRequest(String rawValue, int radix) {
        this.rawValue = rawValue;
        this.radix = radix;
    }

    /*
     * WARNING - void declaration
     */
    static ParseRequest fromString(String stringValue) {
        String radix;
        void rawValue;
        int firstChar;
        if (stringValue.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        char c = stringValue.charAt(0);
        if (stringValue.startsWith("0x") || stringValue.startsWith("0X")) {
            String string = stringValue.substring(2);
            firstChar = 16;
        } else if (rawValue == 35) {
            radix = stringValue.substring(1);
            firstChar = 16;
        } else if (rawValue == 48 && stringValue.length() > 1) {
            radix = stringValue.substring(1);
            firstChar = 8;
        } else {
            radix = stringValue;
            firstChar = 10;
        }
        return new ParseRequest(radix, firstChar);
    }
}

